/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.CommonHadoop;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.HadoopEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.MappingCounters;
import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class PreTreatmentMapper
extends Mapper<LongWritable, Text, Text, Text> {
    static final String FASTQ_FORMAT_KEY = Globals.PARAMETER_PREFIX + ".pretreatment.fastq.format";
    private String counterGroup;
    private static final Splitter TAB_SPLITTER = Splitter.on((char)'\t').trimResults();
    private final List<String> fields = new ArrayList<String>();
    private final ReadSequence read = new ReadSequence();

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        EoulsanLogger.initConsoleHandler();
        EoulsanLogger.getLogger().info("Start of setup()");
        Configuration conf = context.getConfiguration();
        if (!EoulsanRuntime.isRuntime()) {
            HadoopEoulsanRuntime.newEoulsanRuntime(conf);
        }
        FastqFormat fastqFormat = FastqFormat.getFormatFromName((String)conf.get(FASTQ_FORMAT_KEY, "" + EoulsanRuntime.getSettings().getDefaultFastqFormat()));
        this.read.setFastqFormat(fastqFormat);
        EoulsanLogger.getLogger().info("Fastq format: " + fastqFormat);
        this.counterGroup = conf.get(CommonHadoop.COUNTER_GROUP_KEY);
        if (this.counterGroup == null) {
            throw new IOException("No counter group defined");
        }
        EoulsanLogger.getLogger().info("End of setup()");
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        Text outValue;
        Text outKey;
        context.getCounter(this.counterGroup, MappingCounters.INPUT_RAW_READS_COUNTER.counterName()).increment(1L);
        String line = value.toString();
        this.fields.clear();
        for (String e : TAB_SPLITTER.split((CharSequence)line)) {
            this.fields.add(e);
        }
        this.read.setName(this.fields.get(0));
        this.read.setSequence(this.fields.get(1));
        this.read.setQuality(this.fields.get(2));
        if (!this.fields.get(0).contains("/")) {
            outKey = new Text(this.read.getName().split(" ")[0]);
            outValue = new Text(this.read.getName().split(" ")[1] + "\t" + this.read.getSequence() + "\t" + this.read.getQuality());
        } else {
            outKey = new Text(this.read.getName().split("/")[0] + "/");
            outValue = new Text(this.read.getName().split("/")[1] + "\t" + this.read.getSequence() + "\t" + this.read.getQuality());
        }
        context.write((Object)outKey, (Object)outValue);
        context.getCounter(this.counterGroup, MappingCounters.OUTPUT_PRETREATMENT_READS_COUNTER.counterName()).increment(1L);
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
    }
}

