/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop;

import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.MappingCounters;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PreTreatmentReducer
extends Reducer<Text, Text, Text, Text> {
    private String counterGroup;
    private ReadSequence read1 = null;
    private ReadSequence read2 = null;
    private String completeId1;
    private String completeId2;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.counterGroup = conf.get(Globals.PARAMETER_PREFIX + ".counter.group");
        if (this.counterGroup == null) {
            throw new IOException("No counter group defined");
        }
    }

    protected void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        for (Text val : values) {
            String stringVal = val.toString();
            if (stringVal.charAt(0) != '1' && stringVal.charAt(0) != '2') {
                context.getCounter(this.counterGroup, MappingCounters.INVALID_INPUT_PRETREATMENT_READS_COUNTER.counterName()).increment(1L);
                return;
            }
            String[] fields = stringVal.split("\t");
            if (stringVal.charAt(1) == ':') {
                if (stringVal.charAt(0) == '1') {
                    this.read1 = new ReadSequence();
                    this.read1.setSequence(fields[1]);
                    this.read1.setQuality(fields[2]);
                    this.completeId1 = key.toString() + " " + fields[0];
                    continue;
                }
                this.read2 = new ReadSequence();
                this.read2.setSequence(fields[1]);
                this.read2.setQuality(fields[2]);
                this.completeId2 = key.toString() + " " + fields[0];
                continue;
            }
            if (stringVal.charAt(0) == '1') {
                this.read1 = new ReadSequence();
                this.read1.setSequence(fields[1]);
                this.read1.setQuality(fields[2]);
                this.completeId1 = key.toString() + fields[0];
                continue;
            }
            this.read2 = new ReadSequence();
            this.read2.setSequence(fields[1]);
            this.read2.setQuality(fields[2]);
            this.completeId2 = key.toString() + fields[0];
        }
        if (this.read1 == null || this.read2 == null) {
            context.getCounter(this.counterGroup, MappingCounters.INVALID_INPUT_PRETREATMENT_READS_COUNTER.counterName()).increment(1L);
            return;
        }
        Text outKey = new Text(this.completeId1);
        Text outValue = new Text(this.read1.getSequence() + "\t" + this.read1.getQuality() + "\t" + this.completeId2 + "\t" + this.read2.getSequence() + "\t" + this.read2.getQuality());
        context.write((Object)outKey, (Object)outValue);
    }
}

