/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.CommonHadoop;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.HadoopEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.MappingCounters;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.HadoopMappingUtils;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.ReadsFilterHadoopModule;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.HadoopReporterIncrementer;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.MultiReadFilter;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.MultiReadFilterBuilder;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;

public class ReadsFilterMapper
extends Mapper<Text, Text, Text, Text> {
    static final String FASTQ_FORMAT_KEY = Globals.PARAMETER_PREFIX + ".filter.reads.fastq.format";
    static final String READ_FILTER_PARAMETER_KEY_PREFIX = Globals.PARAMETER_PREFIX + ".filter.reads.parameter.";
    private static final Splitter TAB_SPLITTER = Splitter.on((char)'\t').trimResults();
    private final List<String> fields = new ArrayList<String>();
    private MultiReadFilter filter;
    private String counterGroup;
    private final ReadSequence read1 = new ReadSequence();
    private final ReadSequence read2 = new ReadSequence();
    private final Text outValue = new Text();
    private MultipleOutputs<Text, Text> out;
    private String outputFilename1;
    private String outputFilename2;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        EoulsanLogger.initConsoleHandler();
        EoulsanLogger.getLogger().info("Start of setup()");
        Configuration conf = context.getConfiguration();
        if (!EoulsanRuntime.isRuntime()) {
            HadoopEoulsanRuntime.newEoulsanRuntime(conf);
        }
        FastqFormat fastqFormat = FastqFormat.getFormatFromName((String)conf.get(FASTQ_FORMAT_KEY, "" + EoulsanRuntime.getSettings().getDefaultFastqFormat()));
        this.read1.setFastqFormat(fastqFormat);
        this.read2.setFastqFormat(fastqFormat);
        this.counterGroup = conf.get(CommonHadoop.COUNTER_GROUP_KEY);
        if (this.counterGroup == null) {
            throw new IOException("No counter group defined");
        }
        EoulsanLogger.getLogger().info("Fastq format: " + fastqFormat);
        try {
            MultiReadFilterBuilder mrfb = new MultiReadFilterBuilder();
            mrfb.addParameters(HadoopMappingUtils.jobConfToParameters(conf, READ_FILTER_PARAMETER_KEY_PREFIX));
            this.filter = mrfb.getReadFilter((ReporterIncrementer)new HadoopReporterIncrementer((TaskInputOutputContext)context), this.counterGroup);
            EoulsanLogger.getLogger().info("Reads filters to apply: " + Joiner.on((String)", ").join((Iterable)this.filter.getFilterNames()));
        }
        catch (KenetreException e) {
            throw new IOException(e);
        }
        this.out = new MultipleOutputs((TaskInputOutputContext)context);
        this.outputFilename1 = ReadsFilterMapper.createOutputPath(conf, ReadsFilterHadoopModule.OUTPUT_FILE1_KEY);
        this.outputFilename2 = ReadsFilterMapper.createOutputPath(conf, ReadsFilterHadoopModule.OUTPUT_FILE2_KEY);
        EoulsanLogger.getLogger().info("End of setup()");
    }

    private static String createOutputPath(Configuration conf, String key) {
        if (conf == null || key == null) {
            return null;
        }
        String value = conf.get(key);
        return value + "/part";
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        context.getCounter(this.counterGroup, MappingCounters.INPUT_RAW_READS_COUNTER.counterName()).increment(1L);
        String line = value.toString();
        this.fields.clear();
        for (String e : TAB_SPLITTER.split((CharSequence)line)) {
            this.fields.add(e);
        }
        int fieldsSize = this.fields.size();
        if (fieldsSize == 3) {
            this.read1.setName(this.fields.get(0));
            this.read1.setSequence(this.fields.get(1));
            this.read1.setQuality(this.fields.get(2));
            if (this.filter.accept(this.read1)) {
                this.outValue.set(this.read1.toTFQ());
                context.write((Object)key, (Object)this.outValue);
                context.getCounter(this.counterGroup, MappingCounters.OUTPUT_FILTERED_READS_COUNTER.counterName()).increment(1L);
            } else {
                context.getCounter(this.counterGroup, MappingCounters.READS_REJECTED_BY_FILTERS_COUNTER.counterName()).increment(1L);
            }
        } else if (fieldsSize == 6) {
            this.read1.setName(this.fields.get(0));
            this.read1.setSequence(this.fields.get(1));
            this.read1.setQuality(this.fields.get(2));
            this.read2.setName(this.fields.get(3));
            this.read2.setSequence(this.fields.get(4));
            this.read2.setQuality(this.fields.get(5));
            if (this.filter.accept(this.read1, this.read2)) {
                if (this.outputFilename1 == null) {
                    this.outValue.set(this.read1.toTFQ() + "\t" + this.read2.toTFQ());
                    context.write((Object)key, (Object)this.outValue);
                } else {
                    this.outValue.set(this.read1.toTFQ());
                    this.out.write((Object)key, (Object)this.outValue, this.outputFilename1);
                    this.outValue.set(this.read2.toTFQ());
                    this.out.write((Object)key, (Object)this.outValue, this.outputFilename2);
                }
                context.getCounter(this.counterGroup, MappingCounters.OUTPUT_FILTERED_READS_COUNTER.counterName()).increment(1L);
            } else {
                context.getCounter(this.counterGroup, MappingCounters.READS_REJECTED_BY_FILTERS_COUNTER.counterName()).increment(1L);
            }
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        if (this.out != null) {
            this.out.close();
        }
    }
}

