/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop;

import com.google.common.base.Joiner;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.HadoopEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.MappingCounters;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.HadoopMappingUtils;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.SAMHeaderHadoopUtils;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.HadoopReporterIncrementer;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.SAMComparator;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.MultiReadAlignmentFilter;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.MultiReadAlignmentFilterBuilder;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.ReadAlignmentFilter;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.ReadAlignmentFilterBuffer;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMLineParser;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class SAMFilterReducer
extends Reducer<Text, Text, Text, Text> {
    static final String GENOME_DESC_PATH_KEY = Globals.PARAMETER_PREFIX + ".samfilter.genome.desc.file";
    static final String MAP_FILTER_PARAMETER_KEY_PREFIX = Globals.PARAMETER_PREFIX + ".filter.alignments.parameter.";
    private final SAMLineParser parser = new SAMLineParser(new SAMFileHeader());
    private String counterGroup;
    private MultiReadAlignmentFilter filter;
    private final Text outKey = new Text();
    private final Text outValue = new Text();
    private final List<SAMRecord> records = new ArrayList<SAMRecord>();

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        EoulsanLogger.initConsoleHandler();
        EoulsanLogger.getLogger().info("Start of setup()");
        Configuration conf = context.getConfiguration();
        if (!EoulsanRuntime.isRuntime()) {
            HadoopEoulsanRuntime.newEoulsanRuntime(conf);
        }
        this.counterGroup = conf.get(Globals.PARAMETER_PREFIX + ".counter.group");
        if (this.counterGroup == null) {
            throw new IOException("No counter group defined");
        }
        try {
            MultiReadAlignmentFilterBuilder mrafb = new MultiReadAlignmentFilterBuilder();
            mrafb.addParameters(HadoopMappingUtils.jobConfToParameters(conf, MAP_FILTER_PARAMETER_KEY_PREFIX));
            this.filter = mrafb.getAlignmentFilter((ReporterIncrementer)new HadoopReporterIncrementer((TaskInputOutputContext)context), this.counterGroup);
            EoulsanLogger.getLogger().info("Read alignments filters to apply: " + Joiner.on((String)", ").join((Iterable)this.filter.getFilterNames()));
        }
        catch (KenetreException e) {
            throw new IOException(e);
        }
        List<String> samHeader = SAMHeaderHadoopUtils.loadSAMHeaders((JobContext)context);
        this.outKey.set("");
        for (String line : samHeader) {
            this.outValue.set(line);
            context.write((Object)this.outKey, (Object)this.outValue);
        }
        this.parser.getFileHeader().setSequenceDictionary(SAMHeaderHadoopUtils.createSAMSequenceDictionaryFromSAMHeader(samHeader));
        EoulsanLogger.getLogger().info("End of setup()");
    }

    protected void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        ReadAlignmentFilterBuffer rafb = new ReadAlignmentFilterBuffer((ReadAlignmentFilter)this.filter);
        int cptRecords = 0;
        Object strRecord = null;
        this.records.clear();
        for (Text val : values) {
            ++cptRecords;
            strRecord = key.toString() + val.toString();
            rafb.addAlignment(this.parser.parseLine((String)strRecord));
        }
        this.records.addAll(rafb.getFilteredAlignments());
        context.getCounter(this.counterGroup, MappingCounters.ALIGNMENTS_REJECTED_BY_FILTERS_COUNTER.counterName()).increment((long)(cptRecords - this.records.size()));
        this.records.sort((Comparator<SAMRecord>)new SAMComparator());
        for (SAMRecord r : this.records) {
            strRecord = r.getSAMString().replaceAll("\n", "");
            int indexOfFirstTab = ((String)strRecord).indexOf("\t");
            this.outKey.set(((String)strRecord).substring(0, indexOfFirstTab));
            this.outValue.set((String)strRecord);
            context.write((Object)this.outKey, (Object)this.outValue);
            context.getCounter(this.counterGroup, MappingCounters.OUTPUT_FILTERED_ALIGNMENTS_COUNTER.counterName()).increment(1L);
        }
    }
}

