/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.PathUtils;
import fr.ens.biologie.genomique.kenetre.bio.io.BioCharsets;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;

public class SAMHeaderHadoopUtils {
    static final String SAM_HEADER_FILE_PREFIX = "_samheader_";

    public static List<String> loadSAMHeaders(JobContext context) throws IOException {
        Objects.requireNonNull(context, "context argument cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        Path outputPath = new Path(context.getConfiguration().get("mapreduce.output.fileoutputformat.outputdir"));
        FileSystem fs = context.getWorkingDirectory().getFileSystem(context.getConfiguration());
        Path bestFile = null;
        long maxLen = -1L;
        for (FileStatus status : fs.listStatus(outputPath)) {
            if (!status.getPath().getName().startsWith(SAM_HEADER_FILE_PREFIX) || status.getLen() <= maxLen) continue;
            maxLen = status.getLen();
            bestFile = status.getPath();
        }
        if (bestFile == null) {
            throw new IOException("No SAM header file found in reducer output directory: " + outputPath);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(bestFile), BioCharsets.SAM_CHARSET));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
        }
        return result;
    }

    public static SAMSequenceDictionary createSAMSequenceDictionaryFromSAMHeader(List<String> headers) {
        Objects.requireNonNull(headers, "headers argument cannot be null");
        Splitter spliter = Splitter.on((char)'\t');
        SAMSequenceDictionary result = new SAMSequenceDictionary();
        for (String line : headers) {
            if (!line.startsWith("@SQ\t")) continue;
            String sequenceName = null;
            int sequenceLength = -1;
            for (String f : spliter.split((CharSequence)line)) {
                if (f.startsWith("SN:")) {
                    sequenceName = f.substring(3);
                    continue;
                }
                if (!f.startsWith("LN:")) continue;
                try {
                    sequenceLength = Integer.parseInt(f.substring(3));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (sequenceName == null || sequenceLength == -1) continue;
            result.addSequence(new SAMSequenceRecord(sequenceName, sequenceLength));
        }
        return result;
    }

    public static class SAMHeaderWriter {
        private List<String> headers;
        private final String attemptId;

        public boolean writeIfHeaderLine(JobContext context, String line) throws IOException {
            Objects.requireNonNull(line, "line argument cannot be null");
            if (line.length() == 0) {
                return true;
            }
            if (line.charAt(0) == '@') {
                if (this.headers == null) {
                    this.headers = new ArrayList<String>();
                }
                this.headers.add(line);
                return true;
            }
            this.close(context);
            return false;
        }

        public void close(JobContext context) throws IOException {
            if (this.headers != null) {
                Objects.requireNonNull(context, "context argument cannot be null");
                Path outputPath = new Path(context.getConfiguration().get("mapreduce.output.fileoutputformat.outputdir"));
                Path headerPath = new Path(outputPath, SAMHeaderHadoopUtils.SAM_HEADER_FILE_PREFIX + this.attemptId);
                OutputStreamWriter writer = new OutputStreamWriter(PathUtils.createOutputStream(headerPath, context.getConfiguration()), BioCharsets.SAM_CHARSET);
                for (String l : this.headers) {
                    writer.write(l + "\n");
                }
                ((Writer)writer).close();
                this.headers = null;
            }
        }

        public SAMHeaderWriter(String attemptId) {
            Objects.requireNonNull(attemptId, "attemptId argument cannot be null");
            this.attemptId = attemptId;
        }
    }
}

