/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.local;

import fr.ens.biologie.genomique.eoulsan.annotations.HadoopCompatible;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.AbstractBAM2SAMModule;
import fr.ens.biologie.genomique.kenetre.util.LocalReporter;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@HadoopCompatible
public class BAM2SAMLocalModule
extends AbstractBAM2SAMModule {
    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            LocalReporter reporter = new LocalReporter();
            Data inData = context.getInputData(DataFormats.MAPPER_RESULTS_BAM);
            Data outSAMData = context.getOutputData(DataFormats.MAPPER_RESULTS_SAM, inData);
            DataFile samFile = outSAMData.getDataFile();
            DataFile bamFile = inData.getDataFile();
            BAM2SAMLocalModule.convert(bamFile, samFile, (Reporter)reporter, context.getLocalTempDirectory());
            status.setDescription("Convert alignments (" + inData.getName() + ", " + outSAMData.getName() + ")");
            status.setCounters((Reporter)reporter, "bam2sam");
            return status.createTaskResult();
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
    }

    private static void convert(DataFile bamDataFile, DataFile samDataFile, Reporter reporter, File tmpDir) throws IOException {
        InputStream in = bamDataFile.open();
        OutputStream out = samDataFile.create();
        SamReader bamReader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)in));
        bamReader.getFileHeader().setSortOrder(SAMFileHeader.SortOrder.unsorted);
        SAMFileWriter samWriter = new SAMFileWriterFactory().setCreateIndex(false).setTempDirectory(tmpDir).makeSAMWriter(bamReader.getFileHeader(), false, out);
        for (SAMRecord samRecord : bamReader) {
            samWriter.addAlignment(samRecord);
            reporter.incrCounter("bam2sam", "converted records", 1L);
        }
        samWriter.close();
        bamReader.close();
    }
}

