/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.local;

import com.google.common.base.Joiner;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.AbstractReadsFilterModule;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.MappingCounters;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqReader;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqWriter;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.MultiReadFilter;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.ReadFilter;
import fr.ens.biologie.genomique.kenetre.util.LocalReporter;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import java.io.FileNotFoundException;
import java.io.IOException;

@LocalOnly
public class ReadsFilterLocalModule
extends AbstractReadsFilterModule {
    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        LocalReporter reporter = new LocalReporter();
        try {
            Data inData = context.getInputData(DataFormats.READS_FASTQ);
            Data outData = context.getOutputData(DataFormats.READS_FASTQ, inData);
            FastqFormat fastqFormat = inData.getMetadata().getFastqFormat();
            int inFileCount = inData.getDataFileCount();
            if (inFileCount < 1) {
                throw new IOException("No reads file found.");
            }
            if (inFileCount > 2) {
                throw new IOException("Cannot handle more than 2 reads files at the same time.");
            }
            MultiReadFilter filter = this.getReadFilter(context.getGenericLogger(), (ReporterIncrementer)reporter, "reads_filtering");
            EoulsanLogger.getLogger().info("Reads filters to apply: " + Joiner.on((String)", ").join((Iterable)filter.getFilterNames()));
            if (inFileCount == 1) {
                ReadsFilterLocalModule.singleEnd(inData, outData, fastqFormat, (Reporter)reporter, status, (ReadFilter)filter);
            } else {
                ReadsFilterLocalModule.pairedEnd(inData, outData, fastqFormat, (Reporter)reporter, status, (ReadFilter)filter);
            }
        }
        catch (FileNotFoundException e) {
            return status.createTaskResult(e, "File not found: " + e.getMessage());
        }
        catch (IOException e) {
            return status.createTaskResult(e, "Error while filtering reads: " + e.getMessage());
        }
        catch (EoulsanException e) {
            return status.createTaskResult(e, "Error while initializing filter: " + e.getMessage());
        }
        return status.createTaskResult();
    }

    private static void singleEnd(Data inData, Data outData, FastqFormat fastqFormat, Reporter reporter, TaskStatus status, ReadFilter filter) throws IOException {
        DataFile inFile = inData.getDataFile(0);
        DataFile outFile = outData.getDataFile(0);
        ReadsFilterLocalModule.filterFile(inFile, outFile, reporter, filter, fastqFormat);
        status.setDescription("Filter reads (" + inData.getName() + ", " + inFile.getName() + ")");
        status.setCounters(reporter, "reads_filtering");
    }

    private static void pairedEnd(Data inData, Data outData, FastqFormat fastqFormat, Reporter reporter, TaskStatus status, ReadFilter filter) throws IOException {
        ReadsFilterLocalModule.filterFile(inData.getDataFile(0), inData.getDataFile(1), outData.getDataFile(0), outData.getDataFile(1), reporter, filter, fastqFormat);
        status.setDescription("Filter reads (" + inData.getName() + ", " + inData.getDataFile(0).getName() + ", " + inData.getDataFile(1).getName() + ")");
        status.setCounters(reporter, "reads_filtering");
    }

    private static void filterFile(DataFile inFile, DataFile outFile, Reporter reporter, ReadFilter filter, FastqFormat fastqFormat) throws IOException {
        EoulsanLogger.getLogger().info("Filter file: " + inFile);
        EoulsanLogger.getLogger().info("FastqFormat: " + fastqFormat);
        try (FastqReader reader = new FastqReader(inFile.open());
             FastqWriter writer = new FastqWriter(outFile.create());){
            for (ReadSequence read : reader) {
                read.setFastqFormat(fastqFormat);
                reporter.incrCounter("reads_filtering", MappingCounters.INPUT_RAW_READS_COUNTER.counterName(), 1L);
                if (filter.accept(read)) {
                    writer.write(read);
                    reporter.incrCounter("reads_filtering", MappingCounters.OUTPUT_FILTERED_READS_COUNTER.counterName(), 1L);
                    continue;
                }
                reporter.incrCounter("reads_filtering", MappingCounters.READS_REJECTED_BY_FILTERS_COUNTER.counterName(), 1L);
            }
            reader.throwException();
        }
        catch (BadBioEntryException e) {
            throw new IOException("Invalid Fastq format: " + e.getMessage() + " File: " + inFile + " Entry: " + e.getEntry());
        }
    }

    private static void filterFile(DataFile inFile1, DataFile inFile2, DataFile outFile1, DataFile outFile2, Reporter reporter, ReadFilter filter, FastqFormat fastqFormat) throws IOException {
        EoulsanLogger.getLogger().info("Filter files: " + inFile1 + ", " + inFile2 + ", Fastq format: " + fastqFormat);
        try (FastqReader reader2 = new FastqReader(inFile2.open());
             FastqWriter writer1 = new FastqWriter(outFile1.create());
             FastqWriter writer2 = new FastqWriter(outFile2.create());
             FastqReader reader1 = new FastqReader(inFile1.open());){
            for (ReadSequence read1 : reader1) {
                if (!reader2.hasNext()) {
                    reader2.throwException();
                    throw new IOException("Unexcepted end of the second read file. " + inFile1.getName() + " and " + inFile2.getName() + " must have the same number of entries/lines.");
                }
                ReadSequence read2 = reader2.next();
                read1.setFastqFormat(fastqFormat);
                read2.setFastqFormat(fastqFormat);
                reporter.incrCounter("reads_filtering", MappingCounters.INPUT_RAW_READS_COUNTER.counterName(), 1L);
                if (filter.accept(read1, read2)) {
                    writer1.write(read1);
                    writer2.write(read2);
                    reporter.incrCounter("reads_filtering", MappingCounters.OUTPUT_FILTERED_READS_COUNTER.counterName(), 1L);
                    continue;
                }
                reporter.incrCounter("reads_filtering", MappingCounters.READS_REJECTED_BY_FILTERS_COUNTER.counterName(), 1L);
            }
            reader1.throwException();
            reader2.throwException();
            if (reader2.hasNext()) {
                throw new IOException("Unexcepted end of the first read file. " + inFile1.getName() + " and " + inFile2.getName() + " must have the same number of entries/lines.");
            }
        }
        catch (BadBioEntryException e) {
            throw new IOException("Invalid Fastq format: " + e.getMessage() + " File 1: " + inFile1 + " File2:" + inFile2 + " Entry: " + e.getEntry());
        }
    }
}

