/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.local;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.AbstractSAM2BAMModule;
import fr.ens.biologie.genomique.kenetre.util.LocalReporter;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

@LocalOnly
public class SAM2BAMLocalModule
extends AbstractSAM2BAMModule {
    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            LocalReporter reporter = new LocalReporter();
            Data inData = context.getInputData(DataFormats.MAPPER_RESULTS_SAM);
            Data outBAMData = context.getOutputData(DataFormats.MAPPER_RESULTS_BAM, inData);
            Data outBAIData = context.getOutputData(DataFormats.MAPPER_RESULTS_INDEX_BAI, inData);
            DataFile samFile = inData.getDataFile();
            DataFile bamFile = outBAMData.getDataFile();
            DataFile bamIndexFile = outBAIData.getDataFile();
            SAM2BAMLocalModule.convert(samFile, bamFile, bamIndexFile, this.getCompressionLevel(), this.getMaxRecordsInRam(), (Reporter)reporter, context.getLocalTempDirectory());
            status.setDescription("Convert alignments (" + inData.getName() + ", " + samFile.getName() + ", " + bamFile.getName() + "," + bamIndexFile.getName() + ")");
            status.setCounters((Reporter)reporter, "sam2bam");
            return status.createTaskResult();
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
    }

    private static void convert(DataFile samDataFile, DataFile bamDataFile, DataFile bamIndexDataFile, int compressionLevel, int maxRecordsInRam, Reporter reporter, File tmpDir) throws IOException {
        Preconditions.checkArgument((compressionLevel >= 0 && compressionLevel <= 9 ? 1 : 0) != 0, (Object)("Invalid compression level [0-9]: " + compressionLevel));
        SamReader samReader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)samDataFile.open()));
        samReader.getFileHeader().setSortOrder(SAMFileHeader.SortOrder.coordinate);
        File bamFile = bamDataFile.toFile();
        SAMFileWriter samWriter = new SAMFileWriterFactory().setCreateIndex(true).setTempDirectory(tmpDir).setMaxRecordsInRam(maxRecordsInRam).makeBAMWriter(samReader.getFileHeader(), false, bamFile, compressionLevel);
        for (SAMRecord samRecord : samReader) {
            samWriter.addAlignment(samRecord);
            reporter.incrCounter("sam2bam", "sorted records", 1L);
        }
        samReader.close();
        samWriter.close();
        String createdBamIndexFilename = bamDataFile.getName().substring(0, bamDataFile.getName().length() - 1) + "i";
        File createdBamIndexFile = new File(bamDataFile.toFile().getParentFile(), createdBamIndexFilename);
        if (!createdBamIndexFile.renameTo(bamIndexDataFile.toFile())) {
            EoulsanLogger.getLogger().warning("Unable to rename the BAI file " + createdBamIndexFile + " to " + bamIndexDataFile.toFile());
        }
        bamIndexDataFile.symlink(new DataFile(createdBamIndexFile), true);
        bamIndexDataFile.symlink(new DataFile(bamDataFile.getParent(), bamDataFile.getName() + ".bai"), true);
    }
}

