/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.local;

import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.AbstractSAM2FASTQModule;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqWriter;
import fr.ens.biologie.genomique.kenetre.util.LocalReporter;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@LocalOnly
public class SAM2FASTQLocalModule
extends AbstractSAM2FASTQModule {
    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            LocalReporter reporter = new LocalReporter();
            Data inData = context.getInputData(DataFormats.MAPPER_RESULTS_SAM);
            File samTmpFile = File.createTempFile("samTmp", ".sam", context.getLocalTempDirectory());
            Data outData = context.getOutputData(DataFormats.READS_FASTQ, inData);
            DataFile samFile = inData.getDataFile();
            int paired = SAM2FASTQLocalModule.sortConvert(samFile, samTmpFile, (Reporter)reporter, context.getLocalTempDirectory());
            DataFile fastqFile1 = outData.getDataFile(0);
            DataFile fastqFile2 = paired == 3 ? outData.getDataFile(1) : null;
            SAM2FASTQLocalModule.writeConvert(samTmpFile, fastqFile1, fastqFile2, (Reporter)reporter);
            status.setDescription("Convert alignments (" + inData.getName() + "," + outData.getName() + ")");
            status.setCounters((Reporter)reporter, "sam2fastq");
            return status.createTaskResult();
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
    }

    private static void writeConvert(File samDataFile, DataFile fastqDataFile1, DataFile fastqDataFile2, Reporter reporter) throws IOException {
        SamReader samReader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)new FileInputStream(samDataFile)));
        FastqWriter fastqWriter1 = new FastqWriter(fastqDataFile1.create());
        FastqWriter fastqWriter2 = fastqDataFile2 == null ? null : new FastqWriter(fastqDataFile2.create());
        String seq1 = null;
        String seq2 = null;
        String qual1 = null;
        String qual2 = null;
        String currentRecordId = null;
        for (SAMRecord samRecord : samReader) {
            if (currentRecordId != null && !currentRecordId.equals(samRecord.getReadName())) {
                reporter.incrCounter("sam2fastq", "sorted records", 1L);
                SAM2FASTQLocalModule.writeFastq(fastqWriter1, fastqWriter2, currentRecordId, seq1, qual1, seq2, qual2);
                qual2 = null;
                qual1 = null;
                seq2 = null;
                seq1 = null;
            }
            if (samRecord.getReadPairedFlag() && !samRecord.getFirstOfPairFlag()) {
                seq2 = samRecord.getReadString();
                qual2 = samRecord.getBaseQualityString();
            } else {
                seq1 = samRecord.getReadString();
                qual1 = samRecord.getBaseQualityString();
            }
            currentRecordId = samRecord.getReadName();
        }
        if (seq1 != null && seq2 != null) {
            reporter.incrCounter("sam2fastq", "sorted records", 1L);
            SAM2FASTQLocalModule.writeFastq(fastqWriter1, fastqWriter2, currentRecordId, seq1, qual1, seq2, qual2);
        }
        samReader.close();
        fastqWriter1.close();
        if (fastqWriter2 != null) {
            fastqWriter2.close();
        }
    }

    private static int sortConvert(DataFile samDataFile, File samFileTmp, Reporter reporter, File tmpDir) throws IOException {
        SamReader samReader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)samDataFile.open()));
        samReader.getFileHeader().setSortOrder(SAMFileHeader.SortOrder.queryname);
        SAMFileWriter samWriter = new SAMFileWriterFactory().setCreateIndex(false).setTempDirectory(tmpDir).makeSAMWriter(samReader.getFileHeader(), false, samFileTmp);
        boolean firstPair = false;
        boolean secondPair = false;
        for (SAMRecord samRecord : samReader) {
            if (!firstPair && samRecord.getReadPairedFlag() && samRecord.getFirstOfPairFlag()) {
                firstPair = true;
            }
            if (!secondPair && samRecord.getReadPairedFlag() && samRecord.getSecondOfPairFlag()) {
                secondPair = true;
            }
            samRecord.setReadName(samRecord.getReadName().split(" ")[0]);
            samWriter.addAlignment(samRecord);
            reporter.incrCounter("sam2fastq", "converted records", 1L);
        }
        samWriter.close();
        samReader.close();
        int result = 0;
        if (!firstPair && !secondPair) {
            result = 0;
        }
        if (firstPair && !secondPair) {
            result = 1;
        }
        if (!firstPair && secondPair) {
            result = 2;
        }
        if (firstPair && secondPair) {
            result = 3;
        }
        return result;
    }

    private static void writeFastq(FastqWriter fastqWriter1, FastqWriter fastqWriter2, String currentRecordId, String seq1, String qual1, String seq2, String qual2) throws IOException {
        ReadSequence read2;
        ReadSequence read1 = seq1 == null ? null : new ReadSequence(currentRecordId, seq1, qual1);
        ReadSequence readSequence = read2 = seq2 == null ? null : new ReadSequence(currentRecordId, seq2, qual2);
        if (fastqWriter2 != null) {
            if (seq1 != null && seq2 != null) {
                fastqWriter1.write(read1);
                fastqWriter2.write(read2);
            }
        } else if (seq1 != null) {
            fastqWriter1.write(read1);
        } else {
            fastqWriter1.write(read2);
        }
    }
}

