/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mgmt.hadoop;

import fr.ens.biologie.genomique.eoulsan.CommonHadoop;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.HadoopOnly;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.io.Eoulsan1DesignWriter;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.PathUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

@HadoopOnly
public class CopyDesignAndWorkflowFilesToOutputModule
extends AbstractModule {
    public static final String MODULE_NAME = "_copy_design_params_to_output";
    private Configuration conf;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "Copy design and workflow file to output path.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        this.conf = CommonHadoop.createConfiguration(EoulsanRuntime.getSettings());
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Configuration conf = this.conf;
        Path designPath = new Path(context.getDesignFile().getSource());
        Path workflowPath = new Path(context.getWorkflowFile().getSource());
        Path outputPath = new Path(context.getOutputDirectory().getSource());
        Path outputDesignPath = new Path(outputPath, designPath.getName());
        Path outputWorkflowPath = new Path(outputPath, workflowPath.getName());
        try {
            if (!PathUtils.exists(outputDesignPath, conf)) {
                FileSystem outputDesignFs = outputDesignPath.getFileSystem(conf);
                Design design = context.getWorkflow().getDesign();
                new Eoulsan1DesignWriter((OutputStream)outputDesignFs.create(outputDesignPath)).write(design);
            }
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().severe("Unable to copy design file to output path.");
        }
        try {
            if (!PathUtils.exists(outputWorkflowPath, conf)) {
                PathUtils.copy(designPath, outputWorkflowPath, conf);
            }
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().severe("Unable to copy design file to output path.");
        }
        return status.createTaskResult();
    }
}

