/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mgmt.upload;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.annotations.HadoopCompatible;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.HashSet;
import java.util.Set;

@HadoopCompatible
public class DefineDataFormatToDownload
extends AbstractModule {
    protected static final String STEP_NAME = "defineformatstodownload";
    private DataFormat[] inFormats;

    @Override
    public String getName() {
        return STEP_NAME;
    }

    @Override
    public String getDescription() {
        return "define the list of the formats of the files to download at the end of a Hadoop execution";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        String formatNames = null;
        for (Parameter p : stepParameters) {
            if ("formats".equals(p.getName())) {
                formatNames = p.getStringValue();
                continue;
            }
            throw new EoulsanException("Unknown parameter for " + this.getName() + " step: " + p.getName());
        }
        if (formatNames == null) {
            throw new EoulsanException("No format to download set.");
        }
        String[] fields = formatNames.split(",");
        HashSet<DataFormat> formats = new HashSet<DataFormat>();
        DataFormatRegistry registry = DataFormatRegistry.getInstance();
        for (String format : fields) {
            if ("".equals(format.trim())) continue;
            DataFormat df = registry.getDataFormatFromName(format.trim());
            if (df == null) {
                throw new EoulsanException("Format not found : " + format.trim());
            }
            formats.add(df);
        }
        this.inFormats = formats.toArray(new DataFormat[0]);
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (DataFormat df : this.inFormats) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(df.getName());
        }
        String formats = sb.toString();
        EoulsanLogger.getLogger().info("Format to download: " + formats);
        Settings settings = context.getRuntime().getSettings();
        settings.setSetting("dataformat.to.download", formats, false);
        status.setProgressMessage("Formats to download: " + formats);
        return status.createTaskResult();
    }
}

