/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mgmt.upload;

import fr.ens.biologie.genomique.eoulsan.annotations.HadoopOnly;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputDataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatConverter;
import fr.ens.biologie.genomique.eoulsan.data.protocols.StorageDataProtocol;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.modules.mgmt.upload.DataFileDistCp;
import fr.ens.biologie.genomique.eoulsan.modules.mgmt.upload.UploadModule;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.PathUtils;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

@HadoopOnly
public class HadoopUploadModule
extends UploadModule {
    private final Configuration conf;

    @Override
    protected DataFile getUploadedDataFile(DataFile file) throws IOException {
        return new DataFile(this.getDest(), file.getName());
    }

    @Override
    protected DataFile getUploadedDataFile(DataFile file, Step step, Sample sample, String portName, DataFormat format, int fileIndex) throws IOException {
        String filename;
        if (sample == null || portName == null) {
            if (file == null) {
                throw new IOException("Input file is null.");
            }
            filename = file.getName();
        } else {
            filename = StepOutputDataFile.newStandardFilename(step, portName, format, sample, fileIndex, CompressionType.NONE);
        }
        return new DataFile(this.getDest(), filename);
    }

    @Override
    protected void copy(Map<DataFile, DataFile> files) throws IOException {
        if (files == null) {
            throw new NullPointerException("The files argument is null.");
        }
        for (Map.Entry<DataFile, DataFile> e : new HashMap<DataFile, DataFile>(files).entrySet()) {
            DataFile src = e.getKey();
            DataFile dest = e.getValue();
            if (src == null || dest == null) continue;
            if (!src.exists()) {
                throw new IOException("The file does not exists: " + src);
            }
            if (src.toFile() != null) {
                new DataFormatConverter(new DataFile(src.toFile()), dest).convert();
                files.remove(src);
                continue;
            }
            if (!(src.getProtocol() instanceof StorageDataProtocol)) continue;
            DataFile newSrc = ((StorageDataProtocol)src.getProtocol()).getUnderLyingData(src);
            if (src == null) continue;
            files.remove(src);
            files.put(newSrc, dest);
        }
        if (files.size() > 0) {
            Path jobPath = PathUtils.createTempPath(new Path(this.getDest().getSource()), "distcp-", "", this.conf);
            new DataFileDistCp(this.conf, jobPath).copy(files);
        }
    }

    public HadoopUploadModule(DataFile dest, Configuration conf) {
        super(dest);
        if (conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        this.conf = conf;
    }
}

