/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mgmt.upload;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputDataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatConverter;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.modules.mgmt.upload.UploadModule;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.IOException;
import java.util.Map;

@LocalOnly
public class LocalUploadModule
extends UploadModule {
    @Override
    protected DataFile getUploadedDataFile(DataFile file) throws IOException {
        Object filename = file.getName().endsWith(".zip") || file.getName().endsWith(".jar") || file.getName().endsWith(".xml") || file.getName().endsWith(".txt") ? file.getName() : CompressionType.removeCompressionExtension((String)file.getName()) + CompressionType.BZIP2.getExtension();
        return new DataFile(this.getDest(), (String)filename);
    }

    @Override
    protected DataFile getUploadedDataFile(DataFile file, Step step, Sample sample, String portName, DataFormat format, int fileIndex) throws IOException {
        String filename;
        if (sample == null || format == null) {
            if (file == null) {
                throw new IOException("Input file is null.");
            }
            filename = file.getName();
        } else {
            filename = StepOutputDataFile.newStandardFilename(step, portName, format, sample, fileIndex, CompressionType.NONE);
        }
        if (".zip".equals(StringUtils.compressionExtension((String)filename))) {
            return new DataFile(this.getDest(), filename);
        }
        return new DataFile(this.getDest(), CompressionType.removeCompressionExtension((String)filename) + CompressionType.BZIP2.getExtension());
    }

    @Override
    protected void copy(Map<DataFile, DataFile> files) throws IOException {
        if (files == null) {
            throw new NullPointerException("The files argument is null.");
        }
        for (Map.Entry<DataFile, DataFile> e : files.entrySet()) {
            DataFile src = e.getKey();
            DataFile dest = e.getValue();
            if (src == null || dest == null) continue;
            EoulsanLogger.getLogger().info("Convert " + src + " to " + dest);
            new DataFormatConverter(src, dest).convert();
        }
    }

    public LocalUploadModule(DataFile dest) {
        super(dest);
    }
}

