/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mgmt.upload;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.annotations.Terminal;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractWorkflow;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputDataFile;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowContext;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.design.io.Eoulsan1DesignWriter;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.HadoopJarRepackager;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Terminal
public abstract class UploadModule
extends AbstractModule {
    private final DataFile dest;

    protected DataFile getDest() {
        return this.dest;
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        StringBuilder log = new StringBuilder();
        WorkflowContext fullContext = ((AbstractWorkflow)context.getWorkflow()).getWorkflowContext();
        HashMap<DataFile, DataFile> filesToCopy = new HashMap<DataFile, DataFile>();
        File repackagedJarFile = null;
        try {
            Design design = context.getWorkflow().getDesign();
            for (Sample sample : design.getSamples()) {
                filesToCopy.putAll(this.findDataFilesInWorkflow(sample, context));
            }
            this.removeNotExistingDataFile(filesToCopy);
            if (this.getDest().exists()) {
                throw new IOException("The uploading destination already exists: " + this.getDest());
            }
            if (!context.getRuntime().getMode().isHadoopMode()) {
                repackagedJarFile = HadoopJarRepackager.repack();
                DataFile jarDataFile = new DataFile(repackagedJarFile.getAbsolutePath());
                filesToCopy.put(jarDataFile, this.getUploadedDataFile(jarDataFile));
            }
            Settings settings = context.getRuntime().getSettings();
            this.reWriteDesign(context, filesToCopy);
            if (settings.isObfuscateDesign()) {
                DesignUtils.obfuscate(design, settings.isObfuscateDesignRemoveReplicateInfo());
            }
            File newDesignFile = this.writeTempDesignFile(context, design);
            DataFile uploadedDesignDataFile = this.getUploadedDataFile(context.getDesignFile());
            filesToCopy.put(new DataFile(newDesignFile.getAbsolutePath()), uploadedDesignDataFile);
            DataFile currentParamDataFile = context.getWorkflowFile();
            DataFile uploadedParamDataFile = this.getUploadedDataFile(currentParamDataFile);
            filesToCopy.put(currentParamDataFile, uploadedParamDataFile);
            for (Map.Entry e : filesToCopy.entrySet()) {
                log.append("Copy ");
                log.append(e.getKey());
                log.append(" to ");
                log.append(e.getValue());
                log.append('\n');
            }
            this.copy(filesToCopy);
            if (!newDesignFile.delete()) {
                EoulsanLogger.getLogger().warning("Cannot remove temporary design file: " + newDesignFile);
            }
            fullContext.setDesignFile(new DataFile(uploadedDesignDataFile.getSource()));
            fullContext.setWorkflowFile(new DataFile(uploadedParamDataFile.getSource()));
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
        if (!context.getRuntime().getMode().isHadoopMode()) {
            fullContext.setJarFile(new DataFile(this.getDest().toString() + "/" + repackagedJarFile.getName()));
        }
        status.setProgressMessage(log.toString());
        return status.createTaskResult();
    }

    @Override
    public String getName() {
        return "upload";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    protected abstract DataFile getUploadedDataFile(DataFile var1) throws IOException;

    private DataFile getUploadedDataFile(DataFile file, Step step, Sample sample, String portName, DataFormat format) throws IOException {
        return this.getUploadedDataFile(file, step, sample, portName, format, -1);
    }

    protected abstract DataFile getUploadedDataFile(DataFile var1, Step var2, Sample var3, String var4, DataFormat var5, int var6) throws IOException;

    protected abstract void copy(Map<DataFile, DataFile> var1) throws IOException;

    private Map<DataFile, DataFile> findDataFilesInWorkflow(Sample sample, TaskContext context) throws IOException {
        HashMap<DataFile, DataFile> result = new HashMap<DataFile, DataFile>();
        HashSet inFiles = new HashSet();
        for (StepOutputDataFile file : inFiles) {
            DataFile in = file.getDataFile();
            DataFile out = this.getUploadedDataFile(in, file.getStep(), file.getSample(), file.getPortName(), file.getFormat(), file.getFileIndex());
            result.put(in, out);
        }
        return result;
    }

    private void removeNotExistingDataFile(Map<DataFile, DataFile> files) {
        HashSet<DataFile> filesToRemove = new HashSet<DataFile>();
        for (DataFile file : files.keySet()) {
            if (file.exists()) continue;
            filesToRemove.add(file);
        }
        for (DataFile file : filesToRemove) {
            files.remove(file);
        }
    }

    private void reWriteDesign(TaskContext context, Map<DataFile, DataFile> filesToCopy) throws IOException {
        DataFormatRegistry registry = DataFormatRegistry.getInstance();
        Step designStep = context.getWorkflow().getDesignStep();
        Design design = context.getWorkflow().getDesign();
        HashSet<String> fieldWithFiles = new HashSet<String>();
        boolean first = true;
        for (Sample s : design.getSamples()) {
            if (first) {
                for (String fieldName : s.getMetadata().keySet()) {
                    if (registry.getDataFormatForDesignMetadata(fieldName) == null) continue;
                    fieldWithFiles.add(fieldName);
                }
                first = false;
            }
            for (String field : fieldWithFiles) {
                DataFile outFile;
                DataFormat format;
                List<String> oldValues = s.getMetadata().getAsList(field);
                ArrayList<String> newValues = new ArrayList<String>();
                int nValues = oldValues.size();
                if (nValues == 1) {
                    DataFile inFile = new DataFile(oldValues.get(0));
                    Set<DataFormat> formats = registry.getDataFormatsFromExtension(inFile.getExtension());
                    format = formats.size() == 1 ? formats.iterator().next() : inFile.getMetaData().getDataFormat();
                    outFile = format.getMaxFilesCount() == 1 ? this.getUploadedDataFile(inFile, designStep, s, format.getName(), format) : this.getUploadedDataFile(inFile, designStep, s, format.getName(), format, 0);
                    filesToCopy.put(inFile, outFile);
                    newValues.add(outFile.toString());
                } else if (nValues > 1) {
                    for (int i = 0; i < nValues; ++i) {
                        DataFile inFile = new DataFile(oldValues.get(i));
                        format = inFile.getDataFormat();
                        outFile = this.getUploadedDataFile(inFile, designStep, s, format.getName(), format, i);
                        filesToCopy.put(inFile, outFile);
                        newValues.add(outFile.toString());
                    }
                }
                s.getMetadata().set(field, newValues);
            }
        }
    }

    private File writeTempDesignFile(TaskContext context, Design design) throws IOException {
        File result = context.getRuntime().createTempFile("design-", ".txt");
        Eoulsan1DesignWriter writer = new Eoulsan1DesignWriter(FileUtils.createOutputStream((File)result));
        writer.write(design);
        return result;
    }

    public UploadModule(DataFile destination) {
        if (destination == null) {
            throw new NullPointerException("The destination file is null.");
        }
        this.dest = destination;
    }
}

