/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.multiqc;

import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.expression.ExpressionCounterCounter;
import fr.ens.biologie.genomique.eoulsan.modules.multiqc.InputPreprocessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class ExpressionInputPreprocessor
implements InputPreprocessor {
    public static final String REPORT_NAME = "expression";
    private Map<String, Map<String, Integer>> sampleStats;

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public DataFormat getDataFormat() {
        return DataFormats.EXPRESSION_RESULTS_TSV;
    }

    @Override
    public void preprocess(TaskContext context, Data data, File multiQCInputDirectory) throws IOException {
        if (this.sampleStats == null) {
            this.loadExpressionResultStats(context);
        }
        String name = data.getName();
        DataFile expressionFile = data.getDataFile();
        DataFile newFile = new DataFile(multiQCInputDirectory, name + ".txt");
        if (expressionFile.exists()) {
            this.enhanceExpressionFile(expressionFile.toFile(), newFile.toFile(), this.sampleStats.get(name));
        }
    }

    private void loadExpressionResultStats(TaskContext context) throws IOException {
        for (Step step : context.getWorkflow().getSteps()) {
            if (!REPORT_NAME.equals(step.getModuleName())) continue;
            String stepId = step.getId();
            DataFile expressionStepResultFile = new DataFile(context.getJobDirectory(), stepId + ".step.result");
            if (!expressionStepResultFile.exists()) continue;
            this.sampleStats = ExpressionInputPreprocessor.parseStepResultFile(expressionStepResultFile);
        }
    }

    private static Map<String, Map<String, Integer>> parseStepResultFile(DataFile file) throws IOException {
        HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>();
        JsonReader jsonReader = Json.createReader((InputStream)file.open());
        JsonObject object = jsonReader.readObject();
        jsonReader.close();
        JsonObject counters = object.getJsonObject("Counters");
        if (counters == null) {
            return result;
        }
        for (Map.Entry e : counters.entrySet()) {
            String sampleId = (String)e.getKey();
            HashMap<String, Integer> stats = new HashMap<String, Integer>();
            result.put(sampleId, stats);
            JsonObject dict = counters.getJsonObject(sampleId);
            for (ExpressionCounterCounter ec : ExpressionCounterCounter.values()) {
                if (ec.htSeqCountCounterName() == null) continue;
                if (!dict.containsKey((Object)ec.counterName())) {
                    stats.put(ec.htSeqCountCounterName(), 0);
                    continue;
                }
                stats.put(ec.htSeqCountCounterName(), dict.getInt(ec.counterName()));
            }
        }
        return result;
    }

    private void enhanceExpressionFile(File inFile, File outFile, Map<String, Integer> stats) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(inFile, Charset.defaultCharset()));
             FileWriter writer = new FileWriter(outFile, Charset.defaultCharset());){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line + "\n");
            }
            if (stats != null) {
                for (Map.Entry<String, Integer> e : stats.entrySet()) {
                    writer.write("__" + e.getKey() + "\t" + e.getValue() + "\n");
                }
            }
        }
    }
}

