/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.multiqc;

import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.multiqc.InputPreprocessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;

public class FeatureCountsInputPreprocessor
implements InputPreprocessor {
    public static final String REPORT_NAME = "featurecounts";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public DataFormat getDataFormat() {
        return DataFormats.FEATURECOUNTS_SUMMARY_TXT;
    }

    @Override
    public void preprocess(TaskContext context, Data data, File multiQCInputDirectory) throws IOException {
        String name = data.getName();
        DataFile summaryFile = data.getDataFile();
        DataFile finalSummaryFile = new DataFile(multiQCInputDirectory, name + DataFormats.FEATURECOUNTS_SUMMARY_TXT.getDefaultExtension());
        if (summaryFile.exists()) {
            this.rewriteSummaryFile(summaryFile.toFile(), finalSummaryFile.toFile(), name);
        }
    }

    private void rewriteSummaryFile(File inputFile, File outputFile, String dataName) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFile, Charset.defaultCharset()));
             FileWriter writer = new FileWriter(outputFile, Charset.defaultCharset());){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("Status\t")) {
                    writer.write("Status\t" + dataName + ".sam\n");
                    continue;
                }
                writer.write(line + "\n");
            }
        }
    }
}

