/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.requirements;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Progress;
import fr.ens.biologie.genomique.eoulsan.requirements.AbstractRequirement;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.eoulsan.util.r.RSConnection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.rosuda.REngine.REngineException;

public class RserveRequirement
extends AbstractRequirement {
    public static final String REQUIREMENT_NAME = "rserve";
    private static final String SERVER_NAME_PARAMETER = "rserve.servername";
    private String serverName;

    @Override
    public String getName() {
        return REQUIREMENT_NAME;
    }

    @Override
    public void configure(Set<Parameter> parameters) throws EoulsanException {
        block6: for (Parameter p : parameters) {
            switch (p.getName()) {
                case "rserve.servername": {
                    this.serverName = p.getValue();
                    continue block6;
                }
            }
            super.configure(Collections.singleton(p));
        }
    }

    @Override
    public Set<Parameter> getParameters() {
        Set<Parameter> result = super.getParameters();
        result.add(new Parameter(SERVER_NAME_PARAMETER, this.serverName));
        return Collections.unmodifiableSet(result);
    }

    @Override
    public boolean isAvailable() {
        RSConnection connection = new RSConnection(this.serverName);
        try {
            connection.getRConnection();
            connection.disConnect();
        }
        catch (REngineException e) {
            return false;
        }
        return true;
    }

    @Override
    public void install(Progress progress) throws EoulsanException {
    }

    public static Requirement newRserveRequirement(String rserveServerName) {
        return RserveRequirement.newRserveRequirement(rserveServerName, false);
    }

    public static Requirement newRserveRequirement(String rserveServerName, boolean optional) {
        Objects.requireNonNull(rserveServerName, "rserveServerName argument cannot be null");
        Preconditions.checkArgument((!rserveServerName.trim().isEmpty() ? 1 : 0) != 0, (Object)"rserveServerName argument cannot be empty");
        RserveRequirement result = new RserveRequirement();
        result.serverName = rserveServerName.trim();
        result.setInstallable(false);
        result.setOptionnal(optional);
        return result;
    }

    public String toString() {
        return "Rserve server: " + this.serverName;
    }
}

