/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.splitermergers;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.splitermergers.Splitter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class BAMSplitter
implements Splitter {
    private static final int DEFAULT_SPLIT_MAX_ENTRIES = 1000000;
    private int splitMaxEntries = 1000000;
    private boolean splitByChromosomes;

    @Override
    public DataFormat getFormat() {
        return DataFormats.MAPPER_RESULTS_BAM;
    }

    @Override
    public void configure(Set<Parameter> conf) throws EoulsanException {
        block8: for (Parameter p : conf) {
            switch (p.getName()) {
                case "max.entries": {
                    this.splitMaxEntries = p.getIntValueGreaterOrEqualsTo(1);
                    continue block8;
                }
                case "chromosomes": {
                    this.splitByChromosomes = p.getBooleanValue();
                    continue block8;
                }
            }
            throw new EoulsanException("Unknown parameter for " + this.getFormat().getName() + " splitter: " + p.getName());
        }
    }

    @Override
    public void split(DataFile inFile, Iterator<DataFile> outFileIterator) throws IOException {
        if (this.splitByChromosomes) {
            this.splitByChromosomes(inFile, outFileIterator);
        } else {
            this.splitByLineCount(inFile, outFileIterator);
        }
    }

    private void splitByLineCount(DataFile inFile, Iterator<DataFile> outFileIterator) throws IOException {
        File tmpDir = EoulsanRuntime.getRuntime().getTempDirectory();
        SamReader reader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)inFile.open()));
        SAMFileHeader header = reader.getFileHeader();
        int max = this.splitMaxEntries;
        int entryCount = 0;
        SAMFileWriter writer = null;
        for (SAMRecord record : reader) {
            if (entryCount % max == 0) {
                if (writer != null) {
                    writer.close();
                }
                DataFile outFile = outFileIterator.next();
                writer = new SAMFileWriterFactory().setTempDirectory(tmpDir).makeBAMWriter(header, false, outFile.create());
            }
            writer.addAlignment(record);
            ++entryCount;
        }
        reader.close();
        if (writer != null) {
            writer.close();
        }
    }

    public void splitByChromosomes(DataFile inFile, Iterator<DataFile> outFileIterator) throws IOException {
        File tmpDir = EoulsanRuntime.getRuntime().getTempDirectory();
        SamReader reader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)inFile.open()));
        SAMFileHeader header = reader.getFileHeader();
        HashMap<String, SAMFileWriter> writers = new HashMap<String, SAMFileWriter>();
        for (SAMRecord record : reader) {
            SAMFileWriter writer;
            String chromosome = record.getReferenceName();
            if (!writers.containsKey(chromosome)) {
                DataFile outFile = outFileIterator.next();
                writer = new SAMFileWriterFactory().setTempDirectory(tmpDir).makeBAMWriter(header, false, outFile.create());
                writers.put(chromosome, writer);
            } else {
                writer = (SAMFileWriter)writers.get(chromosome);
            }
            writer.addAlignment(record);
        }
        reader.close();
        for (SAMFileWriter writer : writers.values()) {
            writer.close();
        }
    }
}

