/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.splitermergers;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.splitermergers.Splitter;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqReader;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class FastqSplitter
implements Splitter {
    private static final int DEFAULT_SPLIT_MAX_ENTRIES = 1000000;
    private int splitMaxEntries = 1000000;

    @Override
    public DataFormat getFormat() {
        return DataFormats.READS_FASTQ;
    }

    @Override
    public void configure(Set<Parameter> conf) throws EoulsanException {
        block6: for (Parameter p : conf) {
            switch (p.getName()) {
                case "max.entries": {
                    this.splitMaxEntries = p.getIntValueGreaterOrEqualsTo(1);
                    continue block6;
                }
            }
            throw new EoulsanException("Unknown parameter for " + this.getFormat().getName() + " splitter: " + p.getName());
        }
    }

    @Override
    public void split(DataFile inFile, Iterator<DataFile> outFileIterator) throws IOException {
        FastqReader reader = new FastqReader(inFile.open());
        int max = this.splitMaxEntries;
        int entryCount = 0;
        FastqWriter writer = null;
        for (ReadSequence read : reader) {
            if (entryCount % max == 0) {
                if (writer != null) {
                    writer.close();
                }
                writer = new FastqWriter(outFileIterator.next().create());
            }
            writer.write(read);
            ++entryCount;
        }
        reader.close();
        if (writer != null) {
            writer.close();
        }
        try {
            reader.throwException();
        }
        catch (BadBioEntryException e) {
            throw new IOException(e);
        }
    }
}

