/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.ui;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalResizeListener;
import com.googlecode.lanterna.terminal.ansi.UnixTerminal;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.Workflow;
import fr.ens.biologie.genomique.eoulsan.ui.AbstractUI;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LanternaUI
extends AbstractUI
implements TerminalResizeListener {
    private Workflow workflow;
    private final Map<Step, Double> steps = new HashMap<Step, Double>();
    private final Map<Step, Integer> submittedTasks = new HashMap<Step, Integer>();
    private final Map<Step, Integer> runningTasks = new HashMap<Step, Integer>();
    private final Map<Step, Integer> doneTasks = new HashMap<Step, Integer>();
    private final Map<Step, Double> stepProgress = new HashMap<Step, Double>();
    private final Map<Step, Step.StepState> stepState = new HashMap<Step, Step.StepState>();
    private double globalProgress;
    private UnixTerminal terminal;
    private TerminalSize terminalSize;
    private final Map<Step, Integer> stepLines = new HashMap<Step, Integer>();
    private int lastLineYPos;
    private int lineCount;
    private boolean jobDone;

    @Override
    public String getName() {
        return "lanterna";
    }

    @Override
    public void init(Workflow workflow) {
        Objects.requireNonNull(workflow, "workflow is null");
        this.workflow = workflow;
        this.searchSteps();
        if (!this.isInteractiveMode()) {
            return;
        }
        try {
            System.setProperty("com.googlecode.lanterna.terminal.UnixTerminal.catchSpecialCharacters", "false");
            this.terminal = new UnixTerminal();
            this.terminalSize = this.terminal.getTerminalSize();
            this.terminal.addResizeListener((TerminalResizeListener)this);
            System.out.println(Globals.WELCOME_MSG);
            this.lastLineYPos = this.terminal.getCursorPosition().getRow();
        }
        catch (IOException e) {
            LanternaUI.lanternaError(e);
        }
    }

    @Override
    public void notifyStepState(Step step, Step.StepState stepState) {
        if (step == null || step.getWorkflow() != this.workflow || stepState == null) {
            return;
        }
        this.stepState.put(step, stepState);
        switch (stepState) {
            case READY: {
                this.notifyStepState(step, 0, 0, 0.0);
                break;
            }
            case DONE: 
            case FAILED: 
            case ABORTED: {
                this.notifyStepState(step, 0, 0, 1.0);
                break;
            }
        }
    }

    @Override
    public void notifyStepState(Step step, int contextId, String contextName, double progress) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyStepState(Step step, int terminatedTasks, int submittedTasks, double progress) {
        LanternaUI lanternaUI = this;
        synchronized (lanternaUI) {
            if (!this.checkStep(step)) {
                return;
            }
            if (step == null || step.getWorkflow() != this.workflow || !this.steps.containsKey(step)) {
                return;
            }
            Step.StepState state = this.stepState.get(step);
            if (state != Step.StepState.WORKING && state != Step.StepState.PARTIALLY_DONE && state != Step.StepState.DONE && state != Step.StepState.FAILED && state != Step.StepState.ABORTED) {
                return;
            }
            this.stepProgress.put(step, progress);
            this.globalProgress = this.computeGlobalProgress(step, progress);
            this.print(step, false, false, null);
        }
    }

    @Override
    public void notifyStepState(Step step, String note) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyWorkflowSuccess(boolean success, String message) {
        LanternaUI lanternaUI = this;
        synchronized (lanternaUI) {
            if (this.terminal == null || this.jobDone) {
                return;
            }
            this.print(null, true, success, message);
            try {
                this.terminal.close();
            }
            catch (IOException e) {
                LanternaUI.lanternaError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTaskSubmitted(Step step, int contextId) {
        LanternaUI lanternaUI = this;
        synchronized (lanternaUI) {
            if (!this.checkStep(step)) {
                return;
            }
            this.notifyTask(step, contextId, this.submittedTasks, 1);
            this.print(step, false, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTaskRunning(Step step, int contextId) {
        LanternaUI lanternaUI = this;
        synchronized (lanternaUI) {
            if (!this.checkStep(step)) {
                return;
            }
            this.notifyTask(step, contextId, this.runningTasks, 1);
            this.print(step, false, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTaskDone(Step step, int contextId) {
        LanternaUI lanternaUI = this;
        synchronized (lanternaUI) {
            if (!this.checkStep(step)) {
                return;
            }
            this.notifyTask(step, contextId, this.runningTasks, -1);
            this.notifyTask(step, contextId, this.doneTasks, 1);
            this.print(step, false, false, null);
        }
    }

    private void notifyTask(Step step, int contextId, Map<Step, Integer> map, int diff) {
        if (map.containsKey(step)) {
            map.put(step, map.get(step) + diff);
        } else {
            map.put(step, 1);
        }
    }

    private boolean checkStep(Step step) {
        if (this.terminal == null || this.jobDone) {
            return false;
        }
        if (step == null || step.getWorkflow() != this.workflow || !this.steps.containsKey(step)) {
            return false;
        }
        Step.StepState state = this.stepState.get(step);
        return state == Step.StepState.WORKING || state == Step.StepState.PARTIALLY_DONE || state == Step.StepState.DONE || state == Step.StepState.FAILED || state == Step.StepState.ABORTED;
    }

    private synchronized void print(Step step, boolean endWorkflow, boolean success, String successMessage) {
        try {
            this.terminal.setCursorVisible(false);
            if (endWorkflow) {
                if (this.jobDone) {
                    return;
                }
                this.terminal.setCursorVisible(false);
                this.showWorkflowProgress(this.lastLineYPos, 1.0, success, successMessage);
                ++this.lastLineYPos;
                if (this.lastLineYPos < this.terminalSize.getRows() - 1) {
                    this.terminal.putCharacter('\n');
                }
                this.terminal.setCursorPosition(0, this.lastLineYPos);
                this.jobDone = true;
                this.terminal.setCursorVisible(true);
                return;
            }
            this.terminal.setCursorVisible(false);
            if (!this.stepLines.containsKey(step)) {
                this.stepLines.put(step, this.lineCount);
                ++this.lineCount;
                this.terminal.putCharacter('\n');
                if (this.lastLineYPos < this.terminalSize.getRows() - 1) {
                    ++this.lastLineYPos;
                }
            }
            int stepLineY = this.lastLineYPos - this.lineCount + this.stepLines.get(step);
            Integer submittedTasks = this.submittedTasks.get(step);
            Integer runningTasks = this.runningTasks.get(step);
            Integer doneTasks = this.doneTasks.get(step);
            Double stepProgress = this.stepProgress.get(step);
            this.showStepProgress(stepLineY, step.getId(), submittedTasks == null ? 0 : submittedTasks, runningTasks == null ? 0 : runningTasks, doneTasks == null ? 0 : doneTasks, stepProgress == null ? 0.0 : stepProgress, this.stepState.get(step));
            this.showWorkflowProgress(this.lastLineYPos, this.globalProgress, null, null);
            this.terminal.setCursorPosition(0, this.lastLineYPos);
            this.terminal.setCursorVisible(true);
        }
        catch (IOException e) {
            LanternaUI.lanternaError(e);
        }
    }

    private void showStepProgress(int y, String stepId, int submittedTasks, int runningTasks, int terminatedTasks, double progress, Step.StepState state) throws IOException {
        int x = 0;
        x = this.putString(x, y, " * Step ");
        x = this.putStringSGR(x, y, String.format("%-40s", stepId), SGR.BOLD);
        x = this.putString(x, y, " ");
        switch (state) {
            case WORKING: 
            case PARTIALLY_DONE: {
                String plural1 = submittedTasks > 1 ? "s" : "";
                String plural2 = runningTasks > 1 ? "s" : "";
                x = this.putString(x, y, String.format("%3.0f%%    (%d/%d task%s done, %d task%s running)", progress * 100.0, terminatedTasks, submittedTasks, plural1, runningTasks, plural2));
                break;
            }
            case DONE: {
                x = this.putStringColor(x, y, state.name(), (TextColor)TextColor.ANSI.GREEN);
                break;
            }
            case FAILED: 
            case ABORTED: {
                x = this.putStringColor(x, y, state.name(), (TextColor)TextColor.ANSI.RED);
                break;
            }
        }
        this.clearEndOfLine(x, y);
    }

    private void showWorkflowProgress(int y, double progress, Boolean success, String message) throws IOException {
        int x = 0;
        if (success != null) {
            x = this.putString(x, y, " * Workflow                                      ");
            x = success != false ? this.putStringColor(x, y, "DONE  ", (TextColor)TextColor.ANSI.GREEN) : this.putStringColor(x, y, "FAILED", (TextColor)TextColor.ANSI.RED);
            x = this.putString(x, y, "  " + message);
            this.terminal.putCharacter('\n');
        } else {
            x = this.putString(x, y, String.format("%.0f%% workflow done", progress * 100.0));
        }
        this.clearEndOfLine(x, y);
    }

    private int putString(int x, int y, String s) throws IOException {
        if (s == null) {
            return x;
        }
        int currentX = x;
        int max = Math.min(s.length(), this.terminalSize.getColumns() - x);
        for (int i = 0; i < max; ++i) {
            this.terminal.setCursorPosition(currentX, y);
            this.terminal.putCharacter(s.charAt(i));
            ++currentX;
        }
        return currentX;
    }

    private int putStringColor(int x, int y, String s, TextColor color) throws IOException {
        if (color != null) {
            this.terminal.setForegroundColor(color);
        }
        int result = this.putString(x, y, s);
        if (color != null) {
            this.terminal.resetColorAndSGR();
        }
        return result;
    }

    private int putStringSGR(int x, int y, String s, SGR sgr) throws IOException {
        if (sgr != null) {
            this.terminal.enableSGR(sgr);
        }
        int result = this.putString(x, y, s);
        if (sgr != null) {
            this.terminal.disableSGR(sgr);
        }
        return result;
    }

    private void clearEndOfLine(int x, int y) throws IOException {
        int max = this.terminalSize.getColumns();
        for (int i = x; i < max; ++i) {
            this.terminal.setCursorPosition(i, y);
            this.terminal.putCharacter(' ');
        }
    }

    private void searchSteps() {
        for (Step step : this.workflow.getSteps()) {
            if (step == null) continue;
            switch (step.getType()) {
                case CHECKER_STEP: 
                case GENERATOR_STEP: 
                case STANDARD_STEP: {
                    if (step.isSkip()) break;
                    this.steps.put(step, 0.0);
                    break;
                }
            }
        }
    }

    private double computeGlobalProgress(Step step, double progress) {
        if (!this.steps.containsKey(step)) {
            return -1.0;
        }
        this.steps.put(step, progress);
        double sum = 0.0;
        for (double p : this.steps.values()) {
            sum += p;
        }
        return sum / (double)this.steps.size();
    }

    private static void lanternaError(IOException e) {
        System.err.println(e.getMessage());
        e.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResized(Terminal terminal, TerminalSize newSize) {
        LanternaUI lanternaUI = this;
        synchronized (lanternaUI) {
            this.terminalSize = newSize;
            try {
                this.lastLineYPos = terminal.getCursorPosition().getRow();
            }
            catch (IOException e) {
                LanternaUI.lanternaError(e);
            }
        }
    }
}

