/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.util.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;

public abstract class AbstractResourceLoader<S>
implements ResourceLoader<S> {
    private final Multimap<String, String> resources = ArrayListMultimap.create();

    protected abstract InputStream getResourceAsStream(String var1) throws IOException;

    protected abstract S load(InputStream var1, String var2) throws IOException, EoulsanException;

    protected abstract String getResourceName(S var1);

    protected void addResource(String resourceName, String resourcePath) {
        Objects.requireNonNull(resourceName, "resourceName argument cannot be null");
        Objects.requireNonNull(resourcePath, "resourcePath argument cannot be null");
        this.resources.put((Object)resourceName, (Object)resourcePath);
    }

    @Override
    public List<S> loadAllResources() {
        ArrayList<S> result = new ArrayList<S>();
        for (String resourcePath : this.resources.values()) {
            try {
                result.add(this.load(this.getResourceAsStream(resourcePath), resourcePath));
            }
            catch (EoulsanException | IOException e) {
                throw new ServiceConfigurationError("Unable to load resource", e);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<S> loadResources(String resourceName) {
        Objects.requireNonNull(resourceName, "resourceName argument cannot be null");
        if (!this.resources.containsKey((Object)resourceName)) {
            return Collections.emptyList();
        }
        ArrayList<S> result = new ArrayList<S>();
        for (String resourcePath : this.resources.get((Object)resourceName)) {
            try {
                result.add(this.load(this.getResourceAsStream(resourcePath), resourcePath));
            }
            catch (EoulsanException | IOException e) {
                throw new ServiceConfigurationError("Unable to load resource", e);
            }
        }
        return Collections.unmodifiableList(result);
    }
}

