/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private ClassLoader classLoader;

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            String name = desc.getName();
            return Class.forName(name, false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(desc);
        }
    }

    public ClassLoaderObjectInputStream(InputStream in) throws IOException {
        this(Thread.currentThread().getContextClassLoader(), in);
    }

    public ClassLoaderObjectInputStream(ClassLoader classLoader, InputStream in) throws IOException {
        super(in);
        if (classLoader == null) {
            throw new NullPointerException("classLoader argument cannot be null");
        }
        this.classLoader = classLoader;
    }
}

