/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util;

import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.kenetre.bio.AnnotationMatrix;
import fr.ens.biologie.genomique.kenetre.bio.io.TSVAnnotationMatrixReader;
import fr.ens.biologie.genomique.kenetre.translator.AnnotationMatrixTranslator;
import fr.ens.biologie.genomique.kenetre.translator.CommonLinksInfoTranslator;
import fr.ens.biologie.genomique.kenetre.translator.ConcatTranslator;
import fr.ens.biologie.genomique.kenetre.translator.Translator;
import fr.ens.biologie.genomique.kenetre.translator.TranslatorUtils;
import java.io.IOException;
import java.util.Objects;

public class EoulsanTranslatorUtils {
    public static Translator loadTranslator(DataFile annotationFile, DataFile linksFile) throws IOException {
        Objects.requireNonNull(annotationFile, "annotationFile argument cannot be null");
        Translator did = TranslatorUtils.createDuplicatedEnsemblIdTranslator();
        AnnotationMatrix matrix = new TSVAnnotationMatrixReader(annotationFile.open()).read();
        CommonLinksInfoTranslator translator = new CommonLinksInfoTranslator((Translator)new ConcatTranslator(did, (Translator)new AnnotationMatrixTranslator(matrix)));
        EoulsanTranslatorUtils.updateLinks(translator, linksFile);
        return translator;
    }

    public static Translator loadTranslator(DataFile linksFile) throws IOException {
        CommonLinksInfoTranslator translator = new CommonLinksInfoTranslator(TranslatorUtils.createDuplicatedEnsemblIdTranslator());
        EoulsanTranslatorUtils.updateLinks(translator, linksFile);
        return translator;
    }

    public static DataFile getLinksFileFromSettings(Settings settings) {
        if (settings == null) {
            throw new NullPointerException("settings argument cannot be null");
        }
        String value = settings.getAdditionalAnnotationHypertextLinksPath();
        if (value == null) {
            return null;
        }
        return new DataFile(value);
    }

    private static void updateLinks(CommonLinksInfoTranslator translator, DataFile linksFile) throws IOException {
        if (linksFile != null) {
            if (!linksFile.exists()) {
                throw new IOException(linksFile + " doesn't exists.");
            }
            translator.load(linksFile.open());
        }
    }

    private EoulsanTranslatorUtils() {
        throw new IllegalStateException();
    }
}

