/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.util.AbstractResourceLoader;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;

public abstract class FileResourceLoader<S>
extends AbstractResourceLoader<S> {
    private static final String INDEX_FILE = "INDEX";
    private final Class<S> clazz;
    private final List<DataFile> directories = new ArrayList<DataFile>();

    protected abstract String getExtension();

    @Override
    protected InputStream getResourceAsStream(String resourcePath) throws IOException {
        Objects.requireNonNull(resourcePath, "resourcePath argument cannot be null");
        return new DataFile(resourcePath).open();
    }

    @Override
    public void reload() {
        if (this.directories.isEmpty()) {
            return;
        }
        try {
            for (DataFile directory : this.directories) {
                for (String filename : this.findResourcePaths(directory)) {
                    EoulsanLogger.getLogger().fine("Try to load " + this.clazz.getSimpleName() + " from " + directory + "/" + filename + " resource");
                    DataFile file = new DataFile(directory, filename);
                    Object resource = this.load(file.open(), file.getSource());
                    if (resource == null) {
                        throw new EoulsanException("Cannot load resource: " + file);
                    }
                    String resourceName = this.getResourceName(resource);
                    if (resourceName == null) {
                        throw new EoulsanException("Cannot get resource name for resource: " + resource + " (file: " + file + ")");
                    }
                    this.addResource(resourceName, file.getSource());
                }
            }
        }
        catch (EoulsanException | IOException e) {
            throw new ServiceConfigurationError("Unable to load resource: " + e.getMessage(), e);
        }
    }

    private List<String> findResourcePaths(DataFile directory) throws IOException {
        DataFile indexFile = new DataFile(directory, INDEX_FILE);
        if (indexFile.exists()) {
            return this.findResourcePathInIndexFile(indexFile);
        }
        return this.findResourcePathInDirectory(directory);
    }

    private List<String> findResourcePathInIndexFile(DataFile indexFile) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = FileUtils.createBufferedReader((InputStream)indexFile.open());){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String trimLine = line.trim();
                if ("".equals(trimLine) || trimLine.startsWith("#")) continue;
                result.add(trimLine);
            }
        }
        return result;
    }

    private List<String> findResourcePathInDirectory(DataFile directory) {
        ArrayList<String> result = new ArrayList<String>();
        String extension = this.getExtension() == null ? "" : this.getExtension();
        try {
            for (DataFile file : directory.list()) {
                String filename = file.getName();
                if (filename.startsWith(".") || !filename.toLowerCase().endsWith(extension.toLowerCase())) continue;
                result.add(file.getName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public void addResourcePaths(Collection<String> resourcePaths) {
        Objects.requireNonNull(resourcePaths, "resourcePaths argument cannot be null");
        for (String directory : resourcePaths) {
            if ((directory = directory.trim()).isEmpty()) continue;
            this.addResourcePath(new DataFile(directory));
        }
    }

    public void addResourcePath(DataFile resourcePath) {
        Objects.requireNonNull(resourcePath, "baseDir argument cannot be null");
        this.directories.add(resourcePath);
    }

    public boolean removeResourcePath(DataFile resourcePath) {
        Objects.requireNonNull(resourcePath, "baseDir argument cannot be null");
        return this.directories.remove(resourcePath);
    }

    public FileResourceLoader(Class<S> clazz, DataFile resourcePath) {
        Objects.requireNonNull(clazz, "clazz argument cannot be null");
        this.clazz = clazz;
        this.addResourcePath(resourcePath);
    }
}

