/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util;

import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class JarRepack {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final ZipOutputStream zos;

    private void copy(File file) throws IOException {
        ZipInputStream zin = new ZipInputStream(FileUtils.createInputStream((File)file));
        byte[] buffer = new byte[4096];
        ZipEntry entry = zin.getNextEntry();
        do {
            String entryName = entry.getName();
            this.zos.putNextEntry(new ZipEntry(entryName));
            long count = 0L;
            int n = 0;
            while ((n = zin.read(buffer)) != -1) {
                this.zos.write(buffer, 0, n);
                count += (long)n;
            }
            if (entry.getSize() == count) continue;
            throw new IOException("Copied size of zip entry " + count + " is not as excepted: " + entry.getSize());
        } while ((entry = zin.getNextEntry()) != null);
        zin.close();
    }

    public void addFile(File file, String destDir) throws IOException {
        int n;
        if (file == null) {
            return;
        }
        BufferedInputStream origin = null;
        byte[] data = new byte[4096];
        this.zos.putNextEntry(new ZipEntry(destDir + file.getName()));
        FileInputStream fis = new FileInputStream(file);
        origin = new BufferedInputStream(fis, 4096);
        long count = 0L;
        while ((n = origin.read(data, 0, 4096)) != -1) {
            this.zos.write(data, 0, n);
            count += (long)n;
        }
        if (file.length() != count) {
            origin.close();
            throw new IOException("Copied size of zip entry " + count + " is not as excepted: " + file.length());
        }
        origin.close();
    }

    public void close() throws IOException {
        this.zos.close();
    }

    public JarRepack(File inFile, File outFile) throws IOException {
        if (inFile == null) {
            throw new NullPointerException("the inFile argument is null.");
        }
        if (outFile == null) {
            throw new NullPointerException("the outFile argument is null.");
        }
        this.zos = new ZipOutputStream(FileUtils.createOutputStream((File)outFile));
        this.copy(inFile);
    }
}

