/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util;

import com.google.common.base.Joiner;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.io.FileCharsets;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public final class ProcessUtils {
    private static final Charset CHARSET = Charset.forName(System.getProperty("file.encoding"));
    private static Random random;

    public static int system(String cmd) throws IOException {
        EoulsanLogger.getLogger().fine("execute (Thread " + Thread.currentThread().getId() + "): " + cmd);
        Process p = Runtime.getRuntime().exec(cmd);
        try {
            return p.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static int sh(List<String> cmd) throws IOException {
        return ProcessUtils.sh(cmd, null);
    }

    public static int sh(List<String> cmd, File temporaryDirectory) throws IOException {
        Process p = null;
        int exitValue = Integer.MAX_VALUE;
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            if (temporaryDirectory != null) {
                pb.directory(temporaryDirectory);
            }
            EoulsanLogger.getLogger().fine("Execute command: " + cmd.toString());
            p = pb.start();
            Thread terr = new Thread(new ProcessThreadErrOutput(p.getErrorStream()));
            terr.start();
            terr.join();
            exitValue = p.waitFor();
            EoulsanLogger.getLogger().fine("Command exit value: " + exitValue);
        }
        catch (InterruptedException e) {
            EoulsanLogger.getLogger().warning("Process interrupted : " + e.getMessage());
        }
        return exitValue;
    }

    public static void exec(String cmd, boolean stdOutput) throws IOException {
        EoulsanLogger.getLogger().fine("execute (Thread " + Thread.currentThread().getId() + "): " + cmd);
        long startTime = System.currentTimeMillis();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream std = p.getInputStream();
        BufferedReader stdr = new BufferedReader(new InputStreamReader(std, CHARSET));
        String l = null;
        while ((l = stdr.readLine()) != null) {
            if (!stdOutput) continue;
            System.out.println(l);
        }
        InputStream err = p.getInputStream();
        BufferedReader errr = new BufferedReader(new InputStreamReader(err, CHARSET));
        String l2 = null;
        while ((l2 = errr.readLine()) != null) {
            System.err.println(l2);
        }
        stdr.close();
        errr.close();
        ProcessUtils.logEndTime(p, cmd, startTime);
    }

    public static void execWriteOutput(String cmd, File outputFile) throws IOException {
        EoulsanLogger.getLogger().fine("execute (Thread " + Thread.currentThread().getId() + "): " + cmd);
        long startTime = System.currentTimeMillis();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream std = p.getInputStream();
        OutputStream fos = FileUtils.createOutputStream((File)outputFile);
        FileUtils.copy((InputStream)std, (OutputStream)fos);
        InputStream err = p.getInputStream();
        BufferedReader errr = new BufferedReader(new InputStreamReader(err, CHARSET));
        String l2 = null;
        while ((l2 = errr.readLine()) != null) {
            System.err.println(l2);
        }
        fos.close();
        errr.close();
        ProcessUtils.logEndTime(p, cmd, startTime);
    }

    public static String execToString(String cmd) throws IOException {
        return ProcessUtils.execToString(cmd, false, true);
    }

    public static String execToString(String cmd, boolean addStdErr, boolean checkExitCode) throws IOException {
        EoulsanLogger.getLogger().fine("execute (Thread " + Thread.currentThread().getId() + "): " + cmd);
        long startTime = System.currentTimeMillis();
        Process p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
        InputStream std = p.getInputStream();
        BufferedReader stdr = new BufferedReader(new InputStreamReader(std, CHARSET));
        StringBuilder sb = new StringBuilder();
        String l1 = null;
        while ((l1 = stdr.readLine()) != null) {
            sb.append(l1);
            sb.append('\n');
        }
        InputStream err = p.getErrorStream();
        BufferedReader errr = new BufferedReader(new InputStreamReader(err, CHARSET));
        String l2 = null;
        while ((l2 = errr.readLine()) != null) {
            if (addStdErr) {
                sb.append(l2);
                sb.append('\n');
                continue;
            }
            System.err.println(l2);
        }
        stdr.close();
        errr.close();
        if (checkExitCode) {
            ProcessUtils.logEndTime(p, cmd, startTime);
        }
        return sb.toString();
    }

    public static void logEndTime(Process p, String cmd, long startTime) throws IOException {
        try {
            int exitValue = p.waitFor();
            long endTime = System.currentTimeMillis();
            ProcessUtils.throwExitCodeException(exitValue, cmd);
            EoulsanLogger.getLogger().fine("Done (Thread " + Thread.currentThread().getId() + ", exit code: " + exitValue + ") in " + (endTime - startTime) + " ms.");
        }
        catch (InterruptedException e) {
            EoulsanLogger.getLogger().severe("Interrupted exception: " + e.getMessage());
        }
    }

    public static void throwExitCodeException(int exitCode, String command) throws IOException {
        switch (exitCode) {
            case 0: {
                return;
            }
            case 126: {
                throw new IOException("Command invoked cannot execute: " + command);
            }
            case 127: {
                throw new IOException("Command not found: " + command);
            }
            case 134: {
                throw new IOException("Abort: " + command);
            }
            case 139: {
                throw new IOException("Segmentation fault: " + command);
            }
        }
        throw new IOException("Error while executing (exit code " + exitCode + "): " + command);
    }

    public static Set<Integer> getExecutablePids(String executableName) {
        if (executableName == null) {
            return null;
        }
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            String[] lines;
            String s = ProcessUtils.execToString("pgrep -x " + executableName.trim());
            for (String line : lines = s.split("\n")) {
                try {
                    result.add(Integer.parseInt(line));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            return result;
        }
        return result;
    }

    public static void waitUntilExecutableRunning(String executableName) {
        if (executableName == null) {
            return;
        }
        Set<Integer> pids;
        while ((pids = ProcessUtils.getExecutablePids(executableName)).size() != 0) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    public static void waitRandom(int maxMilliseconds) {
        if (maxMilliseconds <= 0) {
            return;
        }
        if (random == null) {
            random = new Random(System.currentTimeMillis());
        }
        try {
            Thread.sleep(random.nextInt(maxMilliseconds));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void execThreadOutput(String cmd) throws IOException {
        EoulsanLogger.getLogger().fine("execute (Thread " + Thread.currentThread().getId() + "): " + cmd);
        long startTime = System.currentTimeMillis();
        Process p = Runtime.getRuntime().exec(cmd);
        BufferedReader stdr = new BufferedReader(new InputStreamReader(p.getInputStream(), CHARSET));
        BufferedReader errr = new BufferedReader(new InputStreamReader(p.getErrorStream(), CHARSET));
        new Thread(new ProcessThreadOutput(stdr, System.out)).start();
        new Thread(new ProcessThreadOutput(errr, System.err)).start();
        ProcessUtils.logEndTime(p, cmd, startTime);
    }

    public static void execThreadOutput(String[] cmd) throws IOException {
        EoulsanLogger.getLogger().fine("execute (Thread " + Thread.currentThread().getId() + "): " + Arrays.toString(cmd));
        long startTime = System.currentTimeMillis();
        Process p = Runtime.getRuntime().exec(cmd);
        BufferedReader stdr = new BufferedReader(new InputStreamReader(p.getInputStream(), CHARSET));
        BufferedReader errr = new BufferedReader(new InputStreamReader(p.getErrorStream(), CHARSET));
        new Thread(new ProcessThreadOutput(stdr, System.out)).start();
        new Thread(new ProcessThreadOutput(errr, System.err)).start();
        ProcessUtils.logEndTime(p, Joiner.on((char)' ').join((Object[])cmd), startTime);
    }

    private ProcessUtils() {
    }

    private static final class ProcessThreadOutput
    implements Runnable {
        final BufferedReader reader;
        final PrintStream pw;

        @Override
        public void run() {
            String l = null;
            try {
                while ((l = this.reader.readLine()) != null) {
                    this.pw.println(l);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        ProcessThreadOutput(BufferedReader reader, PrintStream pw) {
            this.reader = reader;
            this.pw = pw;
        }
    }

    public static final class ProcessThreadErrOutput
    implements Runnable {
        final InputStream err;
        public String exceptionMessage;
        BufferedReader buff;

        @Override
        public void run() {
            try {
                while (new BufferedReader(new InputStreamReader(this.err, FileCharsets.LATIN1_CHARSET)).readLine() != null) {
                }
                this.err.close();
            }
            catch (IOException e) {
                this.exceptionMessage = e.getMessage();
            }
        }

        public ProcessThreadErrOutput(InputStream err) {
            this.err = err;
        }
    }

    public static class ProcessResult {
        private final int exitValue;
        private final String stdout;
        private final String stderr;

        public int getExitValue() {
            return this.exitValue;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        private ProcessResult(int exitValue, String stdout, String stderr) {
            this.exitValue = exitValue;
            this.stdout = stdout;
            this.stderr = stderr;
        }
    }
}

