/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.hadoop;

import fr.ens.biologie.genomique.eoulsan.AbstractEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.HadoopEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.util.LinuxCpuInfo;
import fr.ens.biologie.genomique.eoulsan.util.LinuxMemInfo;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.util.VersionInfo;

public class HadoopInfo {
    private static final String ROOT_PATH = "/";
    private static final String VAR_PATH = "/var";
    private static final String TMP_PATH = "/tmp";

    public static void logHadoopSysInfo() {
        if (EoulsanRuntime.getRuntime().getMode() != AbstractEoulsanRuntime.EoulsanExecMode.AMAZON) {
            return;
        }
        HadoopInfo.logHadoopVersionInfo();
        HadoopEoulsanRuntime runtime = (HadoopEoulsanRuntime)EoulsanRuntime.getRuntime();
        if (EoulsanRuntime.getSettings().isDebug()) {
            HadoopInfo.sysInfo(runtime.getConfiguration());
        }
    }

    private static void sysInfo(Configuration conf) {
        try {
            File tmpDir;
            HadoopInfo.parseCpuinfo();
            HadoopInfo.parseMeminfo();
            HadoopInfo.df(new File(ROOT_PATH), conf);
            HadoopInfo.df(new File(TMP_PATH), conf);
            HadoopInfo.df(new File(VAR_PATH), conf);
            String hadoopTmp = conf.get("hadoop.tmp.dir");
            if (hadoopTmp != null) {
                HadoopInfo.df(new File(hadoopTmp), conf);
            }
            if ((tmpDir = new File(System.getProperty("java.io.tmpdir"))) != null && tmpDir.exists() && tmpDir.isDirectory()) {
                HadoopInfo.df(tmpDir, conf);
            }
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().warning("Error while get system information: " + e.getMessage());
        }
    }

    private static void parseCpuinfo() throws IOException {
        LinuxCpuInfo cpuinfo = new LinuxCpuInfo();
        String modelName = cpuinfo.getModelName();
        String processor = cpuinfo.getProcessor();
        String cpuMHz = cpuinfo.getCPUMHz();
        String bogomips = cpuinfo.getBogoMips();
        String cores = cpuinfo.getCores();
        EoulsanLogger.getLogger().info("SYSINFO CPU model name: " + (modelName == null ? "NA" : modelName));
        EoulsanLogger.getLogger().info("SYSINFO CPU count: " + (String)(processor == null ? "NA" : "" + (Integer.parseInt(processor.trim()) + 1)));
        EoulsanLogger.getLogger().info("SYSINFO CPU cores: " + (cores == null ? "NA" : cores));
        EoulsanLogger.getLogger().info("SYSINFO CPU clock: " + (cpuMHz == null ? "NA" : cpuMHz) + " MHz");
        EoulsanLogger.getLogger().info("SYSINFO Bogomips: " + (bogomips == null ? "NA" : bogomips));
    }

    private static void parseMeminfo() throws IOException {
        LinuxMemInfo meminfo = new LinuxMemInfo();
        String memTotal = meminfo.getMemTotal();
        EoulsanLogger.getLogger().info("SYSINFO Mem Total: " + (memTotal == null ? "NA" : memTotal));
    }

    private static void df(File f, Configuration conf) throws IOException {
        DF df = new DF(f, conf);
        EoulsanLogger.getLogger().info("SYSINFO " + f + " " + StringUtils.sizeToHumanReadable((long)df.getCapacity()) + " capacity, " + StringUtils.sizeToHumanReadable((long)df.getUsed()) + " used, " + StringUtils.sizeToHumanReadable((long)df.getAvailable()) + " available, " + df.getPercentUsed() + "% used");
    }

    private static void logHadoopVersionInfo() {
        EoulsanLogger.getLogger().info("SYSINFO Hadoop version: " + VersionInfo.getVersion());
        EoulsanLogger.getLogger().info("SYSINFO Hadoop revision: " + VersionInfo.getRevision());
        EoulsanLogger.getLogger().info("SYSINFO Hadoop date: " + VersionInfo.getDate());
        EoulsanLogger.getLogger().info("SYSINFO Hadoop user: " + VersionInfo.getUser());
        EoulsanLogger.getLogger().info("SYSINFO Hadoop url: " + VersionInfo.getUrl());
    }
}

