/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.hadoop;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.util.JarRepack;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class HadoopJarRepackager {
    private static final String DIR_IN_JAR = "lib/";
    private final List<File> jarFiles = new ArrayList<File>();
    private File srcJar;

    private void doIt(File destJarFile) throws IOException {
        if (this.srcJar == null) {
            throw new IOException("No source jar found in the paths of libraries to repack.");
        }
        EoulsanLogger.getLogger().info("Repackage " + this.srcJar + " in " + destJarFile);
        JarRepack jarRepack = new JarRepack(this.srcJar, destJarFile);
        for (File file : this.jarFiles) {
            jarRepack.addFile(file, DIR_IN_JAR);
            EoulsanLogger.getLogger().fine("Add in repackaged jar file: " + file.getName());
        }
        jarRepack.close();
    }

    public static void repack(File destJarFile) throws IOException {
        HadoopJarRepackager hjr = new HadoopJarRepackager(System.getProperty(Globals.LIBS_TO_HADOOP_REPACK_PROPERTY), Globals.APP_NAME_LOWER_CASE + "-" + Globals.APP_VERSION_STRING + ".jar");
        hjr.doIt(destJarFile);
    }

    public static File repack() throws IOException {
        File result = new File(HadoopJarRepackager.createRepackagedJarName());
        if (!result.exists()) {
            HadoopJarRepackager.repack(result);
        }
        return result;
    }

    private static String createRepackagedJarName() {
        return Globals.APP_NAME_LOWER_CASE + "-" + Globals.APP_VERSION_STRING + (String)(Globals.DEBUG ? "-" + Globals.APP_BUILD_NUMBER : "") + "-" + Integer.toHexString(System.getProperty(Globals.LIBS_TO_HADOOP_REPACK_PROPERTY).trim().hashCode()) + ".jar";
    }

    private HadoopJarRepackager(String libPaths, String jarName) {
        if (libPaths == null) {
            throw new IllegalArgumentException("The paths of libraries to repack is null.");
        }
        if (jarName == null) {
            throw new IllegalArgumentException("The name of the jar to repack is null.");
        }
        for (String filename : libPaths.split(":")) {
            File file = new File(filename.trim());
            if (!file.exists() || !file.isFile()) continue;
            if (jarName.equals(file.getName())) {
                this.srcJar = file;
                continue;
            }
            this.jarFiles.add(file);
        }
    }
}

