/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.hadoop;

import fr.ens.biologie.genomique.eoulsan.CommonHadoop;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.core.workflow.EmergencyStopTask;
import fr.ens.biologie.genomique.eoulsan.core.workflow.EmergencyStopTasks;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;

public class HadoopJobEmergencyStopTask
implements EmergencyStopTask {
    private final String jobId;

    @Override
    public void stop() {
        EoulsanLogger.getLogger().info("Try to kill " + this.jobId + " Hadoop job");
        Configuration conf = CommonHadoop.createConfiguration();
        try {
            RunningJob job;
            JobClient client = new JobClient(conf);
            if (client != null && (job = client.getJob(JobID.forName((String)this.jobId))) != null) {
                job.killJob();
            }
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().severe(e.getMessage());
        }
        EoulsanLogger.getLogger().info("Hadoop job " + this.jobId + " killed");
    }

    public int hashCode() {
        return this.jobId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HadoopJobEmergencyStopTask)) {
            return false;
        }
        HadoopJobEmergencyStopTask that = (HadoopJobEmergencyStopTask)obj;
        return this.jobId.equals(that.jobId);
    }

    public static void addHadoopJobEmergencyStopTask(Job job) throws IOException, InterruptedException {
        EmergencyStopTasks.getInstance().add(new HadoopJobEmergencyStopTask(job));
    }

    public static void removeHadoopJobEmergencyStopTask(Job job) throws IOException, InterruptedException {
        EmergencyStopTasks.getInstance().remove(new HadoopJobEmergencyStopTask(job));
    }

    public HadoopJobEmergencyStopTask(Job job) throws IOException, InterruptedException {
        Objects.requireNonNull(job, "job argument cannot be null");
        this.jobId = job.getStatus().getJobID().toString();
    }
}

