/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.locker;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class Ticket
implements Comparable<Ticket>,
Serializable {
    private static final long serialVersionUID = -7934169474677708526L;
    private final int pid;
    private final long threadId;
    private final long creationTime;
    private final long nanoCreationTime;
    private final String description;
    private long lastActiveTime;
    private boolean working;

    public int getPid() {
        return this.pid;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getDescription() {
        return this.description;
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean working) {
        this.working = working;
    }

    public void updateLastActiveTime() {
        this.lastActiveTime = System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ticket)) {
            return false;
        }
        Ticket t = (Ticket)o;
        return this.creationTime == t.creationTime && this.nanoCreationTime == t.nanoCreationTime && this.pid == t.pid && this.threadId == t.threadId;
    }

    public int hashCode() {
        return Ticket.hashCode(this.creationTime, this.nanoCreationTime, this.pid, this.threadId);
    }

    @Override
    public int compareTo(Ticket ticket) {
        if (ticket == null) {
            return 1;
        }
        int comp1 = Long.compare(this.creationTime, ticket.creationTime);
        if (comp1 != 0) {
            return comp1;
        }
        int comp2 = Long.compare(this.nanoCreationTime, ticket.nanoCreationTime);
        if (comp2 != 0) {
            return comp2;
        }
        int comp3 = Integer.compare(this.pid, ticket.pid);
        if (comp3 != 0) {
            return comp3;
        }
        return Long.compare(this.threadId, ticket.threadId);
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        return dateFormat.format(new Date(this.creationTime)) + " " + dateFormat.format(new Date(this.lastActiveTime)) + " " + dateFormat.format(new Date(System.currentTimeMillis() - this.creationTime)) + " " + (this.working ? "WORKING" : "NOT WORKING") + " [" + this.pid + "." + this.threadId + " " + (this.description != null ? this.description : "") + "]";
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    private static int getCurrentPid() {
        String beanName = ManagementFactory.getRuntimeMXBean().getName();
        int index = beanName.indexOf(64);
        return Integer.parseInt(beanName.substring(0, index));
    }

    public Ticket() {
        this((String)null);
    }

    public Ticket(String description) {
        this(Ticket.getCurrentPid(), Thread.currentThread().getId(), System.currentTimeMillis(), System.nanoTime(), description, -1L, false);
    }

    public Ticket(Ticket ticket) {
        this(ticket.pid, ticket.threadId, ticket.creationTime, ticket.nanoCreationTime, ticket.description, ticket.lastActiveTime, ticket.working);
    }

    public Ticket(int pid, long threadId, long creationTime, long nanoCreationTime, String description, long lastActiveTime, boolean working) {
        this.pid = pid;
        this.threadId = threadId;
        this.creationTime = creationTime;
        this.nanoCreationTime = nanoCreationTime;
        this.description = description;
        this.lastActiveTime = lastActiveTime == -1L ? this.creationTime : lastActiveTime;
        this.working = working;
    }
}

