/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.locker;

import fr.ens.biologie.genomique.eoulsan.util.locker.Locker;
import fr.ens.biologie.genomique.eoulsan.util.locker.Ticket;
import fr.ens.biologie.genomique.eoulsan.util.locker.TicketScheduler;
import fr.ens.biologie.genomique.eoulsan.util.locker.TicketSchedulerServer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class TicketLocker
implements Locker {
    static final String RMI_SERVICE_PREFIX = "locker-";
    private LockerThread thread;
    private final String lockerName;
    private final int port;
    private final String description;

    private TicketScheduler getStub() {
        try {
            Registry registry = LocateRegistry.getRegistry(this.port);
            return (TicketScheduler)registry.lookup(RMI_SERVICE_PREFIX + this.lockerName);
        }
        catch (IOException | NotBoundException e) {
            return null;
        }
    }

    @Override
    public void lock() throws IOException {
        if (this.thread == null) {
            this.thread = new LockerThread(new Ticket(this.description));
        }
        Thread t = new Thread(this.thread);
        t.start();
        while (t.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void unlock() throws IOException {
        this.thread.end();
    }

    private void startRMIServer(Set<Ticket> tickets) {
        new Thread(() -> {
            try {
                LocateRegistry.createRegistry(this.port);
                TicketSchedulerServer.newServer(tickets, this.lockerName, this.port);
                while (true) {
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException | RemoteException exception) {
                return;
            }
        }).start();
    }

    public TicketLocker(String lockerName, int port) {
        this(lockerName, port, null);
    }

    public TicketLocker(String lockerName, int port, String description) {
        this.lockerName = lockerName;
        this.port = port;
        this.description = description;
    }

    public static void main(String[] args) throws RemoteException, MalformedURLException {
        if (args.length < 2) {
            System.err.println("List current lock tickets\nSyntax: java " + TicketLocker.class.getName() + " locker_name server_port");
            return;
        }
        TicketLocker locker = new TicketLocker(args[0], Integer.parseInt(args[1]), null);
        ArrayList<Ticket> tickets = new ArrayList<Ticket>(locker.getStub().getTickets(null));
        Collections.sort(tickets);
        for (Ticket t : tickets) {
            System.out.println(t);
        }
    }

    private final class LockerThread
    implements Runnable {
        private final Ticket ticket;
        private Set<Ticket> tickets;

        @Override
        public void run() {
            while (true) {
                try {
                    TicketScheduler stub = TicketLocker.this.getStub();
                    if (stub != null) {
                        this.tickets = stub.getTickets(this.ticket);
                        if (this.tickets == null || this.tickets.isEmpty() || this.tickets.size() == 1) {
                            this.ticket.setWorking(true);
                            return;
                        }
                        for (Ticket t : this.tickets) {
                            if (!t.equals(this.ticket) || !t.isWorking()) continue;
                            return;
                        }
                    } else {
                        TicketLocker.this.startRMIServer(this.tickets);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public void end() {
            TicketScheduler stub = TicketLocker.this.getStub();
            if (stub != null) {
                try {
                    stub.endWork(this.ticket);
                }
                catch (RemoteException e) {
                    TicketLocker.this.startRMIServer(this.tickets);
                }
            }
        }

        private LockerThread(Ticket ticket) {
            this.ticket = ticket;
        }
    }
}

