/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.locker;

import fr.ens.biologie.genomique.eoulsan.util.locker.LockerUtils;
import fr.ens.biologie.genomique.eoulsan.util.locker.Ticket;
import fr.ens.biologie.genomique.eoulsan.util.locker.TicketScheduler;
import fr.ens.biologie.genomique.kenetre.util.Utils;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TicketSchedulerServer
implements TicketScheduler {
    private static TicketSchedulerServer serverInstance;
    private Ticket currentActive;
    private final Map<Ticket, Ticket> tickets = new HashMap<Ticket, Ticket>();
    private final Set<Ticket> toRemove = new HashSet<Ticket>();
    private static final int maxWorkingTime = 120000;
    private static final int deadTime = 30000;
    private static final int checkingTime = 10000;
    private long lastCheckingTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Ticket> getTickets(Ticket ticket) {
        if (ticket == null) {
            return new HashSet<Ticket>(this.tickets.values());
        }
        Map<Ticket, Ticket> map = this.tickets;
        synchronized (map) {
            if (this.tickets.containsKey(ticket)) {
                Ticket t = this.tickets.get(ticket);
                t.updateLastActiveTime();
            } else {
                ticket.updateLastActiveTime();
                this.tickets.put(ticket, ticket);
            }
            this.check();
            return new HashSet<Ticket>(this.tickets.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endWork(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        Map<Ticket, Ticket> map = this.tickets;
        synchronized (map) {
            if (ticket.equals(this.currentActive)) {
                this.tickets.remove(this.currentActive);
                this.currentActive = null;
                this.check();
            }
        }
    }

    private void check() {
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.lastCheckingTime + 10000L) {
            for (Ticket ticket : this.tickets.values()) {
                if (ticket.isWorking()) continue;
                if (currentTime <= ticket.getLastActiveTime() + 30000L) continue;
                this.toRemove.add(ticket);
            }
            if (this.currentActive != null) {
                if (currentTime > this.currentActive.getLastActiveTime() + 120000L) {
                    this.toRemove.add(this.currentActive);
                    this.currentActive = null;
                }
            }
            Set<Integer> pids = LockerUtils.getJVMsPIDs();
            for (Ticket t : this.tickets.values()) {
                if (pids.contains(t.getPid())) continue;
                if (t.equals(this.currentActive)) {
                    this.currentActive = null;
                }
                this.toRemove.add(t);
            }
            for (Ticket t : this.toRemove) {
                this.tickets.remove(t);
            }
            this.toRemove.clear();
            this.lastCheckingTime = currentTime;
        }
        if (this.currentActive == null && this.tickets.size() > 0) {
            for (Ticket ticket : this.tickets.values()) {
                if (!ticket.isWorking()) continue;
                this.currentActive = ticket;
                return;
            }
            ArrayList<Ticket> list = new ArrayList<Ticket>(this.tickets.values());
            Collections.sort(list);
            this.currentActive = (Ticket)list.get(0);
            this.currentActive.setWorking(true);
        }
    }

    private TicketSchedulerServer(Set<Ticket> tickets) {
        if (tickets != null) {
            for (Ticket t : tickets) {
                this.tickets.put(t, t);
            }
            this.check();
        }
    }

    public static synchronized void newServer(Set<Ticket> tickets, String lockerName, int port) {
        if (serverInstance != null) {
            return;
        }
        try {
            serverInstance = new TicketSchedulerServer(tickets);
            TicketScheduler stub = (TicketScheduler)UnicastRemoteObject.exportObject((Remote)serverInstance, 0);
            Registry registry = LocateRegistry.getRegistry(port);
            if (registry == null) {
                registry = LocateRegistry.createRegistry(port);
            }
            registry.bind("locker-" + lockerName, stub);
        }
        catch (Exception e) {
            Utils.nop();
        }
    }
}

