/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.r;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.util.r.RExecutor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRExecutor
implements RExecutor {
    private static final String R_FILE_EXTENSION = ".R";
    private static final String SWEAVE_FILE_EXTENSION = ".Rnw";
    private final List<String> inputFilenames = new ArrayList<String>();
    private final File outputDirectory;
    private final File temporaryDirectory;

    protected abstract void putFile(DataFile var1, String var2) throws IOException;

    protected abstract void removeFile(String var1) throws IOException;

    protected abstract void executeRScript(File var1, boolean var2, String var3, File var4, String ... var5) throws IOException;

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    @Override
    public void openConnection() throws IOException {
        if (!this.outputDirectory.isDirectory()) {
            throw new IOException("The output directory does not exist or is not a directory: " + this.outputDirectory);
        }
        if (!this.temporaryDirectory.isDirectory()) {
            throw new IOException("The output directory does not exist or is not a directory: " + this.outputDirectory);
        }
    }

    @Override
    public void closeConnection() throws IOException {
        this.inputFilenames.clear();
    }

    @Override
    public void getOutputFiles() throws IOException {
    }

    @Override
    public void putInputFile(DataFile inputFile) throws IOException {
        if (inputFile == null) {
            throw new NullPointerException("inputFile argument cannot be null");
        }
        this.putFile(inputFile, inputFile.getName());
    }

    @Override
    public void putInputFile(DataFile inputFile, String outputFilename) throws IOException {
        if (inputFile == null) {
            throw new NullPointerException("inputFile argument cannot be null");
        }
        if (outputFilename == null) {
            throw new NullPointerException("inputFilename argument cannot be null");
        }
        if (this.inputFilenames.contains(outputFilename)) {
            throw new IOException("Cannot overwrite input file on Rserve: " + outputFilename);
        }
        this.inputFilenames.add(outputFilename);
        this.putFile(inputFile, outputFilename);
    }

    @Override
    public void removeInputFiles() throws IOException {
        for (String inputFilename : this.inputFilenames) {
            this.removeFile(inputFilename);
        }
    }

    @Override
    public void executeRScript(String rScript, boolean sweave, String sweaveOutput, boolean saveRscript, String description, DataFile workflowOutputDir, String ... scriptArguments) throws IOException {
        if (rScript == null) {
            throw new NullPointerException("rScript argument cannot be null");
        }
        if (description == null) {
            throw new NullPointerException("description argument cannot be null");
        }
        File rScriptFile = new File(this.outputDirectory, description + (sweave ? SWEAVE_FILE_EXTENSION : R_FILE_EXTENSION));
        FileWriter writer = new FileWriter(rScriptFile, Charset.defaultCharset());
        writer.write(rScript);
        ((Writer)writer).close();
        this.executeRScript(rScriptFile, sweave, sweaveOutput, workflowOutputDir.toFile(), scriptArguments);
        if (!saveRscript && !rScriptFile.delete()) {
            EoulsanLogger.logWarning("Cannot removing temporary R script: " + rScriptFile);
        }
    }

    protected AbstractRExecutor(File outputDirectory, File temporaryDirectory) throws IOException {
        if (outputDirectory == null) {
            throw new NullPointerException("outputDirectory argument cannot be null");
        }
        if (temporaryDirectory == null) {
            throw new NullPointerException("outputDirectory argument cannot be null");
        }
        this.outputDirectory = outputDirectory;
        this.temporaryDirectory = temporaryDirectory;
    }
}

