/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.r;

import com.google.common.base.Joiner;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFiles;
import fr.ens.biologie.genomique.eoulsan.util.ProcessUtils;
import fr.ens.biologie.genomique.eoulsan.util.r.AbstractRExecutor;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.process.SimpleProcess;
import fr.ens.biologie.genomique.kenetre.util.process.SystemSimpleProcess;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProcessRExecutor
extends AbstractRExecutor {
    public static final String REXECUTOR_NAME = "process";
    public static final String RSCRIPT_EXECUTABLE = "Rscript";
    protected static final String LANG_ENVIRONMENT_VARIABLE = "LANG";
    protected static final String DEFAULT_R_LANG = "C";
    private final Set<String> filenamesToKeep = new HashSet<String>();

    @Override
    public String getName() {
        return REXECUTOR_NAME;
    }

    @Override
    protected void putFile(DataFile inputFile, String outputFilename) throws IOException {
        File outputDir = this.getOutputDirectory().getAbsoluteFile();
        DataFile outputFile = new DataFile(outputDir, outputFilename);
        if (ProcessRExecutor.isSameLocalPath(inputFile, outputFile)) {
            return;
        }
        if (outputFile.exists()) {
            throw new IOException("The output file already exists: " + outputFile);
        }
        if (!inputFile.isLocalFile() || inputFile.getCompressionType().isCompressed()) {
            DataFiles.copy(inputFile, outputFile);
        } else {
            File parentDir = inputFile.toFile().getParentFile().getAbsoluteFile();
            if (!parentDir.equals(outputDir) || !inputFile.getName().equals(outputFilename)) {
                inputFile.symlink(outputFile, true);
            } else {
                this.filenamesToKeep.add(outputFilename);
            }
        }
    }

    @Override
    public void writerFile(String content, String outputFilename) throws IOException {
        if (content == null) {
            throw new NullPointerException("content argument cannot be null");
        }
        if (outputFilename == null) {
            throw new NullPointerException("outputFilename argument cannot be null");
        }
        DataFile outputFile = new DataFile(this.getOutputDirectory(), outputFilename);
        if (outputFile.exists()) {
            throw new IOException("The output file already exists: " + outputFile);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(outputFile.create());){
            writer.write(content);
        }
    }

    @Override
    protected void removeFile(String filename) throws IOException {
        if (this.filenamesToKeep.contains(filename)) {
            return;
        }
        File file = new File(this.getOutputDirectory(), filename);
        if (!file.delete()) {
            EoulsanLogger.logWarning("Cannot remove file used by R: " + file);
        }
    }

    protected List<String> createCommand(File rScriptFile, boolean sweave, String sweaveOuput, String ... scriptArguments) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(RSCRIPT_EXECUTABLE);
        if (sweave) {
            result.add("-e");
            StringBuilder sb = new StringBuilder();
            sb.append("Sweave(\"");
            sb.append(rScriptFile.getAbsolutePath());
            sb.append('\"');
            if (sweaveOuput != null) {
                sb.append(", output=\"");
                sb.append(sweaveOuput);
                sb.append('\"');
            }
            sb.append(')');
            result.add(sb.toString());
        } else {
            result.add(rScriptFile.getAbsolutePath());
        }
        if (scriptArguments != null) {
            Collections.addAll(result, scriptArguments);
        }
        return result;
    }

    protected SimpleProcess createSimpleProcess() throws IOException {
        return new SystemSimpleProcess();
    }

    @Override
    protected void executeRScript(File rScriptFile, boolean sweave, String sweaveOuput, File workflowOutputDir, String ... scriptArguments) throws IOException {
        SimpleProcess process = this.createSimpleProcess();
        List<String> commandLine = this.createCommand(rScriptFile, sweave, sweaveOuput, scriptArguments);
        File stdoutFile = ProcessRExecutor.changeFileExtension(rScriptFile, ".out");
        int exitValue = process.execute(commandLine, this.getOutputDirectory(), Collections.singletonMap(LANG_ENVIRONMENT_VARIABLE, DEFAULT_R_LANG), this.getTemporaryDirectory(), stdoutFile, stdoutFile, true, new File[]{workflowOutputDir});
        ProcessUtils.throwExitCodeException(exitValue, Joiner.on((char)' ').join(commandLine));
    }

    protected static File changeFileExtension(File file, String newExtension) {
        if (file == null) {
            return null;
        }
        if (newExtension == null) {
            return file;
        }
        String newFilename = StringUtils.filenameWithoutExtension((String)file.getName()) + newExtension;
        return new File(file.getParent(), newFilename);
    }

    @Override
    public void closeConnection() throws IOException {
        this.filenamesToKeep.clear();
        super.closeConnection();
    }

    protected static boolean isSameLocalPath(DataFile a, DataFile b) {
        if (a.equals(b)) {
            return true;
        }
        if (a.isLocalFile()) {
            File fa = a.toFile().getAbsoluteFile();
            File fb = b.toFile().getAbsoluteFile();
            return fa.equals(fb);
        }
        return false;
    }

    protected ProcessRExecutor(File outputDirectory, File temporaryDirectory) throws IOException {
        super(outputDirectory, temporaryDirectory);
    }
}

