/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.r;

import fr.ens.biologie.genomique.eoulsan.util.r.DockerRExecutor;
import fr.ens.biologie.genomique.eoulsan.util.r.ProcessRExecutor;
import fr.ens.biologie.genomique.eoulsan.util.r.RExecutor;
import fr.ens.biologie.genomique.eoulsan.util.r.RserveRExecutor;
import java.io.File;
import java.io.IOException;

public class RExecutorFactory {
    public static RExecutor newRExecutor(Mode mode, String rServeServer, String dockerImage, File outputDirectory, File temporaryDirectory) throws IOException {
        if (mode != null) {
            switch (mode) {
                case PROCESS: {
                    return new ProcessRExecutor(outputDirectory, temporaryDirectory);
                }
                case RSERVE: {
                    return new RserveRExecutor(outputDirectory, temporaryDirectory, rServeServer);
                }
                case DOCKER: {
                    return new DockerRExecutor(outputDirectory, temporaryDirectory, dockerImage);
                }
            }
        }
        if (rServeServer != null) {
            return new RserveRExecutor(outputDirectory, temporaryDirectory, rServeServer);
        }
        if (dockerImage != null) {
            return new DockerRExecutor(outputDirectory, temporaryDirectory, dockerImage);
        }
        return new ProcessRExecutor(outputDirectory, temporaryDirectory);
    }

    public static enum Mode {
        PROCESS,
        RSERVE,
        DOCKER;


        public static Mode parse(String name) {
            if (name == null) {
                return null;
            }
            for (Mode m : Mode.values()) {
                if (!m.name().toLowerCase().equals(name.toLowerCase().trim())) continue;
                return m;
            }
            return null;
        }
    }
}

