/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.r;

import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RFileInputStream;
import org.rosuda.REngine.Rserve.RserveException;

public class RSConnection {
    private final String serverName;
    private RConnection rconnection;
    private static final int BUFFER_SIZE = 32768;

    public RConnection getRConnection() throws REngineException {
        if (this.rconnection == null) {
            this.connect();
        }
        return this.rconnection;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void writeStringAsFile(String outputFilename, String value) throws REngineException {
        if (outputFilename == null) {
            return;
        }
        try {
            BufferedWriter writer = FileUtils.createBufferedWriter((OutputStream)this.getFileOutputStream(outputFilename));
            if (value != null) {
                writer.write(value);
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            throw new REngineException((REngine)this.getRConnection(), "Error: " + e.getMessage());
        }
    }

    public InputStream getFileInputStream(String filename) throws REngineException {
        RConnection c = this.getRConnection();
        try {
            return c.openFile(filename);
        }
        catch (IOException e) {
            throw new REngineException((REngine)c, "Error: " + e.getMessage());
        }
    }

    public OutputStream getFileOutputStream(String filename) throws REngineException {
        RConnection c = this.getRConnection();
        try {
            return c.createFile(filename);
        }
        catch (IOException e) {
            throw new REngineException((REngine)c, "Error: " + e.getMessage());
        }
    }

    public void putFile(File inputFile, String rServeFilename) throws REngineException {
        Objects.requireNonNull(inputFile, "inputFile argument cannot be null");
        Objects.requireNonNull(rServeFilename, "rServeFilename argument cannot be null");
        try {
            this.putFile(new FileInputStream(inputFile), rServeFilename);
        }
        catch (FileNotFoundException e) {
            throw new REngineException((REngine)this.getRConnection(), "file not found: " + e.getMessage());
        }
    }

    public void putFile(InputStream is, String rServeFilename) throws REngineException {
        Objects.requireNonNull(is, "inputFile argument cannot be null");
        Objects.requireNonNull(rServeFilename, "rServeFilename argument cannot be null");
        try {
            OutputStream os = this.getFileOutputStream(rServeFilename);
            byte[] buf = new byte[32768];
            int i = 0;
            while ((i = is.read(buf)) != -1) {
                os.write(buf, 0, i);
            }
            is.close();
            os.close();
        }
        catch (REngineException e) {
            throw new REngineException((REngine)this.getRConnection(), "Unable to put file: " + e.getMessage());
        }
        catch (IOException e) {
            throw new REngineException((REngine)this.getRConnection(), "Unable to create report: " + e.getMessage());
        }
    }

    public void getFile(String rServeFilename, File outputFile) throws REngineException {
        try {
            InputStream is = this.getFileInputStream(rServeFilename);
            FileOutputStream os = new FileOutputStream(outputFile);
            byte[] buf = new byte[32768];
            int i = 0;
            while ((i = is.read(buf)) != -1) {
                ((OutputStream)os).write(buf, 0, i);
            }
            is.close();
            ((OutputStream)os).close();
        }
        catch (REngineException e) {
            throw new REngineException((REngine)this.getRConnection(), "Unable to get file");
        }
        catch (FileNotFoundException e) {
            throw new REngineException((REngine)this.getRConnection(), "file not found");
        }
        catch (IOException e) {
            throw new REngineException((REngine)this.getRConnection(), "Unable to create report.");
        }
    }

    public void getFilesIntoZip(List<String> rServeFilenames, File zipFile) throws REngineException {
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            byte[] buf = new byte[32768];
            for (String f : rServeFilenames) {
                InputStream is = this.getFileInputStream(f);
                out.putNextEntry(new ZipEntry(f));
                int i = 0;
                while ((i = is.read(buf)) != -1) {
                    out.write(buf, 0, i);
                }
                out.closeEntry();
                is.close();
            }
            out.close();
        }
        catch (REngineException e) {
            throw new REngineException((REngine)this.getRConnection(), "Unable to get file");
        }
        catch (FileNotFoundException e) {
            throw new REngineException((REngine)this.getRConnection(), "File not found");
        }
        catch (IOException e) {
            throw new REngineException((REngine)this.getRConnection(), "Unable to get file");
        }
    }

    public void removeFile(String filename) throws REngineException {
        RConnection c = this.getRConnection();
        try {
            REXP exists = c.eval("file.exists(\"" + filename + "\")");
            if (exists.asInteger() == 1) {
                c.voidEval("file.remove(\"" + filename + "\")");
            }
        }
        catch (REXPMismatchException | RserveException e) {
            throw new REngineException((REngine)c, "RServe exception: " + (Exception)e);
        }
    }

    public void removeAllFiles() throws REngineException, REXPMismatchException {
        for (String file : this.listFiles()) {
            this.removeFile(file);
        }
    }

    public void setCommandArgs(List<String> arguments) throws REngineException {
        if (arguments == null) {
            throw new NullPointerException("arguments argument cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("f <- function(trailingOnly = FALSE) { c(");
        boolean first = true;
        for (String arg : arguments) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append('\'');
            sb.append(arg);
            sb.append('\'');
        }
        sb.append(") }");
        RConnection c = this.getRConnection();
        try {
            c.voidEval(sb.toString());
        }
        catch (RserveException e) {
            throw new REngineException((REngine)c, "RServe exception: " + e);
        }
    }

    public void executeRCode(String source) throws REngineException {
        if (source == null) {
            return;
        }
        RConnection c = this.getRConnection();
        try {
            c.voidEval("source(\"" + source + "\")");
        }
        catch (RserveException e) {
            throw new REngineException((REngine)c, "RServe exception: " + e);
        }
    }

    public void executeRnwCode(String source) throws REngineException {
        this.executeRnwCode(source, null);
    }

    public void executeRnwCode(String source, String latexOutput) throws REngineException {
        if (source == null) {
            return;
        }
        RConnection c = this.getRConnection();
        StringBuilder sb = new StringBuilder();
        sb.append("Sweave(\"");
        sb.append(source);
        sb.append('\"');
        if (latexOutput != null) {
            sb.append(", output=\"");
            sb.append(latexOutput);
            sb.append('\"');
        }
        sb.append(')');
        try {
            c.voidEval(sb.toString());
        }
        catch (RserveException e) {
            throw new REngineException((REngine)c, "Rserve exception: " + e);
        }
    }

    public Image loadImage(String filename) throws REngineException {
        if (filename == null) {
            return null;
        }
        RConnection c = this.getRConnection();
        if (c == null) {
            throw new REngineException(null, "Connection is null");
        }
        try {
            RFileInputStream is = c.openFile(filename);
            ArrayList<byte[]> buffers = new ArrayList<byte[]>();
            int bufSize = 65536;
            byte[] buf = new byte[bufSize];
            int imgLength = 0;
            int n = 0;
            do {
                if ((n = is.read(buf)) == bufSize) {
                    buffers.add(buf);
                    buf = new byte[bufSize];
                }
                if (n <= 0) continue;
                imgLength += n;
            } while (n >= bufSize);
            if (imgLength < 10) {
                throw new REngineException((REngine)c, "Cannot load image, check R output, probably R didn't produce anything.");
            }
            byte[] imgCode = new byte[imgLength];
            int imgPos = 0;
            for (byte[] b : buffers) {
                System.arraycopy(b, 0, imgCode, imgPos, bufSize);
                imgPos += bufSize;
            }
            if (n > 0) {
                System.arraycopy(buf, 0, imgCode, imgPos, n);
            }
            is.close();
            c.removeFile("test.jpg");
            return Toolkit.getDefaultToolkit().createImage(imgCode);
        }
        catch (IOException e) {
            throw new REngineException((REngine)c, "Error while load image");
        }
        catch (RserveException e) {
            throw new REngineException((REngine)c, "Error while removing image from server");
        }
    }

    public byte[] getFileAsArray(String filename) throws REngineException {
        RConnection c = this.getRConnection();
        if (c == null) {
            throw new REngineException(null, "Connection is null");
        }
        try {
            RFileInputStream is = c.openFile(filename);
            ArrayList<byte[]> buffers = new ArrayList<byte[]>();
            int bufSize = 65536;
            byte[] buf = new byte[bufSize];
            int imgLength = 0;
            int n = 0;
            do {
                if ((n = is.read(buf)) == bufSize) {
                    buffers.add(buf);
                    buf = new byte[bufSize];
                }
                if (n <= 0) continue;
                imgLength += n;
            } while (n >= bufSize);
            if (imgLength < 10) {
                throw new REngineException((REngine)c, "Cannot load files, check R output, probably R didn't produce anything.");
            }
            byte[] imgCode = new byte[imgLength];
            int imgPos = 0;
            for (byte[] b : buffers) {
                System.arraycopy(b, 0, imgCode, imgPos, bufSize);
                imgPos += bufSize;
            }
            if (n > 0) {
                System.arraycopy(buf, 0, imgCode, imgPos, n);
            }
            is.close();
            return imgCode;
        }
        catch (IOException e) {
            throw new REngineException((REngine)c, "Error while loading files");
        }
    }

    public RFileInputStream openFile(String filename) throws REngineException {
        RFileInputStream file;
        RConnection c = this.getRConnection();
        try {
            file = c.openFile(filename);
        }
        catch (IOException e) {
            throw new REngineException((REngine)c, "Error while opening file");
        }
        return file;
    }

    public void getAllFiles(File outPath) throws REngineException, REXPMismatchException {
        if (outPath == null) {
            throw new NullPointerException("outPath argument cannot be null");
        }
        for (String file : this.listFiles()) {
            this.getFile(file, new File(outPath, file));
        }
    }

    public List<String> listFiles() throws REngineException, REXPMismatchException {
        RConnection c = this.getRConnection();
        String[] files = c.eval("list.files()").asStrings();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    private void connect() throws REngineException {
        try {
            this.rconnection = new RConnection(this.serverName);
        }
        catch (RserveException e) {
            throw new REngineException((REngine)this.rconnection, "Unable to connect to the server: " + e.getMessage());
        }
    }

    public void disConnect() {
        if (this.rconnection != null) {
            this.rconnection.close();
            this.rconnection = null;
        }
    }

    public RSConnection() {
        this(null);
    }

    public RSConnection(String serverName) {
        this.serverName = serverName == null ? "127.0.0.1" : serverName.trim();
    }
}

