/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.r;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.util.r.AbstractRExecutor;
import fr.ens.biologie.genomique.eoulsan.util.r.RSConnection;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.List;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class RserveRExecutor
extends AbstractRExecutor {
    public static final String REXECUTOR_NAME = "rserve";
    private final String serverName;
    protected RSConnection rConnection;

    @Override
    public String getName() {
        return REXECUTOR_NAME;
    }

    @Override
    public void getOutputFiles() throws IOException {
        this.checkConnection();
        try {
            List<String> filenames = this.rConnection.listFiles();
            for (String filename : filenames) {
                this.rConnection.getFile(filename, new File(this.getOutputDirectory(), filename));
                this.removeFile(filename);
            }
        }
        catch (REXPMismatchException | REngineException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void openConnection() throws IOException {
        super.openConnection();
        this.rConnection = new RSConnection(this.serverName);
    }

    @Override
    public void closeConnection() throws IOException {
        this.rConnection.disConnect();
        this.rConnection = null;
    }

    @Override
    protected void removeFile(String filename) throws IOException {
        this.checkConnection();
        if (EoulsanRuntime.getSettings().isKeepRServeFiles()) {
            return;
        }
        try {
            this.rConnection.removeFile(filename);
        }
        catch (REngineException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void putFile(DataFile inputFile, String inputFilename) throws IOException {
        this.checkConnection();
        EoulsanLogger.getLogger().info("Put file on RServe: " + inputFile + " to " + inputFilename);
        try {
            this.rConnection.putFile(inputFile.open(), inputFilename);
        }
        catch (REngineException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writerFile(String content, String outputFilename) throws IOException {
        this.checkConnection();
        if (content == null) {
            throw new NullPointerException("content argument cannot be null");
        }
        if (outputFilename == null) {
            throw new NullPointerException("outputFilename argument cannot be null");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(this.rConnection.getFileOutputStream(outputFilename));){
            writer.write(content);
        }
        catch (REngineException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void executeRScript(File rScriptFile, boolean sweave, String sweaveOuput, File workflowOutputDir, String ... scriptArguments) throws IOException {
        this.checkConnection();
        String rScriptOnRservePath = rScriptFile.getName();
        this.putFile(new DataFile(rScriptFile), rScriptOnRservePath);
        try {
            if (scriptArguments != null) {
                this.rConnection.setCommandArgs(Arrays.asList(scriptArguments));
            }
            if (sweave) {
                EoulsanLogger.getLogger().info("Execute RNW script: " + rScriptFile);
                this.rConnection.executeRnwCode(rScriptOnRservePath, sweaveOuput);
            } else {
                EoulsanLogger.getLogger().info("Execute R script: " + rScriptFile);
                this.rConnection.executeRCode(rScriptOnRservePath);
            }
        }
        catch (REngineException e) {
            throw new IOException(e);
        }
        this.removeFile(rScriptOnRservePath);
    }

    private void checkConnection() {
        if (this.rConnection == null) {
            throw new IllegalStateException("Connection has not been openned");
        }
    }

    public RserveRExecutor(File outputDirectory, File temporaryDirectory, String serverName) throws IOException {
        super(outputDirectory, temporaryDirectory);
        if (serverName == null) {
            throw new NullPointerException("serverName cannot be null");
        }
        this.serverName = serverName.trim();
    }
}

