/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.seqdoop.hadoop_bam.FormatConstants;
import org.seqdoop.hadoop_bam.FormatException;

public class SequencedFragment
implements Writable {
    protected Text sequence = new Text();
    protected Text quality = new Text();
    protected String instrument;
    protected Integer runNumber;
    protected String flowcellId;
    protected Integer lane;
    protected Integer tile;
    protected Integer xpos;
    protected Integer ypos;
    protected Integer read;
    protected Boolean filterPassed;
    protected Integer controlNumber;
    protected String indexSequence;
    protected static final int Instrument_Present = 1;
    protected static final int RunNumber_Present = 2;
    protected static final int FlowcellId_Present = 4;
    protected static final int Lane_Present = 8;
    protected static final int Tile_Present = 16;
    protected static final int Xpos_Present = 32;
    protected static final int Ypos_Present = 64;
    protected static final int Read_Present = 128;
    protected static final int FilterPassed_Present = 256;
    protected static final int ControlNumber_Present = 512;
    protected static final int IndexSequence_Present = 1024;

    public void clear() {
        this.sequence.clear();
        this.quality.clear();
        this.instrument = null;
        this.runNumber = null;
        this.flowcellId = null;
        this.lane = null;
        this.tile = null;
        this.xpos = null;
        this.ypos = null;
        this.read = null;
        this.filterPassed = null;
        this.controlNumber = null;
        this.indexSequence = null;
    }

    public Text getSequence() {
        return this.sequence;
    }

    public Text getQuality() {
        return this.quality;
    }

    public void setInstrument(String v) {
        this.instrument = v;
    }

    public void setRunNumber(Integer v) {
        this.runNumber = v;
    }

    public void setFlowcellId(String v) {
        this.flowcellId = v;
    }

    public void setLane(Integer v) {
        this.lane = v;
    }

    public void setTile(Integer v) {
        this.tile = v;
    }

    public void setXpos(Integer v) {
        this.xpos = v;
    }

    public void setYpos(Integer v) {
        this.ypos = v;
    }

    public void setRead(Integer v) {
        this.read = v;
    }

    public void setFilterPassed(Boolean v) {
        this.filterPassed = v;
    }

    public void setControlNumber(Integer v) {
        this.controlNumber = v;
    }

    public void setIndexSequence(String v) {
        this.indexSequence = v;
    }

    public void setSequence(Text seq) {
        if (seq == null) {
            throw new IllegalArgumentException("can't have a null sequence");
        }
        this.sequence = seq;
    }

    public void setQuality(Text qual) {
        if (qual == null) {
            throw new IllegalArgumentException("can't have a null quality");
        }
        this.quality = qual;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public Integer getRunNumber() {
        return this.runNumber;
    }

    public String getFlowcellId() {
        return this.flowcellId;
    }

    public Integer getLane() {
        return this.lane;
    }

    public Integer getTile() {
        return this.tile;
    }

    public Integer getXpos() {
        return this.xpos;
    }

    public Integer getYpos() {
        return this.ypos;
    }

    public Integer getRead() {
        return this.read;
    }

    public Boolean getFilterPassed() {
        return this.filterPassed;
    }

    public Integer getControlNumber() {
        return this.controlNumber;
    }

    public String getIndexSequence() {
        return this.indexSequence;
    }

    public String toString() {
        String delim = "\t";
        StringBuilder builder = new StringBuilder(800);
        builder.append(this.instrument).append(delim);
        builder.append(this.runNumber).append(delim);
        builder.append(this.flowcellId).append(delim);
        builder.append(this.lane).append(delim);
        builder.append(this.tile).append(delim);
        builder.append(this.xpos).append(delim);
        builder.append(this.ypos).append(delim);
        builder.append(this.indexSequence).append(delim);
        builder.append(this.read).append(delim);
        builder.append(this.sequence).append(delim);
        builder.append(this.quality).append(delim);
        builder.append(this.filterPassed == null || this.filterPassed != false ? 1 : 0);
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SequencedFragment) {
            SequencedFragment otherFrag = (SequencedFragment)other;
            if (this.instrument == null && otherFrag.instrument != null || this.instrument != null && !this.instrument.equals(otherFrag.instrument)) {
                return false;
            }
            if (this.runNumber == null && otherFrag.runNumber != null || this.runNumber != null && !this.runNumber.equals(otherFrag.runNumber)) {
                return false;
            }
            if (this.flowcellId == null && otherFrag.flowcellId != null || this.flowcellId != null && !this.flowcellId.equals(otherFrag.flowcellId)) {
                return false;
            }
            if (this.lane == null && otherFrag.lane != null || this.lane != null && !this.lane.equals(otherFrag.lane)) {
                return false;
            }
            if (this.tile == null && otherFrag.tile != null || this.tile != null && !this.tile.equals(otherFrag.tile)) {
                return false;
            }
            if (this.xpos == null && otherFrag.xpos != null || this.xpos != null && !this.xpos.equals(otherFrag.xpos)) {
                return false;
            }
            if (this.ypos == null && otherFrag.ypos != null || this.ypos != null && !this.ypos.equals(otherFrag.ypos)) {
                return false;
            }
            if (this.read == null && otherFrag.read != null || this.read != null && !this.read.equals(otherFrag.read)) {
                return false;
            }
            if (this.filterPassed == null && otherFrag.filterPassed != null || this.filterPassed != null && !this.filterPassed.equals(otherFrag.filterPassed)) {
                return false;
            }
            if (this.controlNumber == null && otherFrag.controlNumber != null || this.controlNumber != null && !this.controlNumber.equals(otherFrag.controlNumber)) {
                return false;
            }
            if (this.indexSequence == null && otherFrag.indexSequence != null || this.indexSequence != null && !this.indexSequence.equals(otherFrag.indexSequence)) {
                return false;
            }
            if (!this.sequence.equals((Object)otherFrag.sequence)) {
                return false;
            }
            return this.quality.equals((Object)otherFrag.quality);
        }
        return false;
    }

    public int hashCode() {
        int result = this.sequence.hashCode();
        result = 31 * result + this.quality.hashCode();
        result = 31 * result + (this.instrument != null ? this.instrument.hashCode() : 0);
        result = 31 * result + (this.runNumber != null ? this.runNumber.hashCode() : 0);
        result = 31 * result + (this.flowcellId != null ? this.flowcellId.hashCode() : 0);
        result = 31 * result + (this.lane != null ? this.lane.hashCode() : 0);
        result = 31 * result + (this.tile != null ? this.tile.hashCode() : 0);
        result = 31 * result + (this.xpos != null ? this.xpos.hashCode() : 0);
        result = 31 * result + (this.ypos != null ? this.ypos.hashCode() : 0);
        result = 31 * result + (this.read != null ? this.read.hashCode() : 0);
        result = 31 * result + (this.filterPassed != null ? this.filterPassed.hashCode() : 0);
        result = 31 * result + (this.controlNumber != null ? this.controlNumber.hashCode() : 0);
        result = 31 * result + (this.indexSequence != null ? this.indexSequence.hashCode() : 0);
        return result;
    }

    public static void convertQuality(Text quality, FormatConstants.BaseQualityEncoding current, FormatConstants.BaseQualityEncoding target) {
        if (current == target) {
            throw new IllegalArgumentException("current and target quality encodinds are the same (" + (Object)((Object)current) + ")");
        }
        byte[] bytes = quality.getBytes();
        int len = quality.getLength();
        int illuminaSangerDistance = 31;
        if (current == FormatConstants.BaseQualityEncoding.Illumina && target == FormatConstants.BaseQualityEncoding.Sanger) {
            int i = 0;
            while (i < len) {
                if (bytes[i] < 64 || bytes[i] > 126) {
                    throw new FormatException("base quality score out of range for Illumina Phred+64 format (found " + (bytes[i] - 64) + " but acceptable range is [0," + 62 + "]).\nMaybe qualities are encoded in Sanger format?\n");
                }
                int n = i++;
                bytes[n] = (byte)(bytes[n] - 31);
            }
        } else if (current == FormatConstants.BaseQualityEncoding.Sanger && target == FormatConstants.BaseQualityEncoding.Illumina) {
            int i = 0;
            while (i < len) {
                if (bytes[i] < 33 || bytes[i] > 126) {
                    throw new FormatException("base quality score out of range for Sanger Phred+64 format (found " + (bytes[i] - 33) + " but acceptable range is [0," + 93 + "]).\nMaybe qualities are encoded in Illumina format?\n");
                }
                int n = i++;
                bytes[n] = (byte)(bytes[n] + 31);
            }
        } else {
            throw new IllegalArgumentException("unsupported BaseQualityEncoding transformation from " + (Object)((Object)current) + " to " + (Object)((Object)target));
        }
    }

    public static int verifyQuality(Text quality, FormatConstants.BaseQualityEncoding encoding) {
        byte min;
        byte max;
        if (encoding == FormatConstants.BaseQualityEncoding.Illumina) {
            max = 126;
            min = 64;
        } else if (encoding == FormatConstants.BaseQualityEncoding.Sanger) {
            max = 126;
            min = 33;
        } else {
            throw new IllegalArgumentException("Unsupported base encoding quality " + (Object)((Object)encoding));
        }
        byte[] bytes = quality.getBytes();
        int len = quality.getLength();
        for (int i = 0; i < len; ++i) {
            if (bytes[i] >= min && bytes[i] <= max) continue;
            return i;
        }
        return -1;
    }

    public void readFields(DataInput in) throws IOException {
        this.clear();
        this.sequence.readFields(in);
        this.quality.readFields(in);
        int presentFlags = WritableUtils.readVInt((DataInput)in);
        if ((presentFlags & 1) != 0) {
            this.instrument = WritableUtils.readString((DataInput)in);
        }
        if ((presentFlags & 2) != 0) {
            this.runNumber = WritableUtils.readVInt((DataInput)in);
        }
        if ((presentFlags & 4) != 0) {
            this.flowcellId = WritableUtils.readString((DataInput)in);
        }
        if ((presentFlags & 8) != 0) {
            this.lane = WritableUtils.readVInt((DataInput)in);
        }
        if ((presentFlags & 0x10) != 0) {
            this.tile = WritableUtils.readVInt((DataInput)in);
        }
        if ((presentFlags & 0x20) != 0) {
            this.xpos = WritableUtils.readVInt((DataInput)in);
        }
        if ((presentFlags & 0x40) != 0) {
            this.ypos = WritableUtils.readVInt((DataInput)in);
        }
        if ((presentFlags & 0x80) != 0) {
            this.read = WritableUtils.readVInt((DataInput)in);
        }
        if ((presentFlags & 0x100) != 0) {
            this.filterPassed = WritableUtils.readVInt((DataInput)in) == 1;
        }
        if ((presentFlags & 0x200) != 0) {
            this.controlNumber = WritableUtils.readVInt((DataInput)in);
        }
        if ((presentFlags & 0x400) != 0) {
            this.indexSequence = WritableUtils.readString((DataInput)in);
        }
    }

    public void write(DataOutput out) throws IOException {
        this.sequence.write(out);
        this.quality.write(out);
        int presentFlags = 0;
        if (this.instrument != null) {
            presentFlags |= 1;
        }
        if (this.runNumber != null) {
            presentFlags |= 2;
        }
        if (this.flowcellId != null) {
            presentFlags |= 4;
        }
        if (this.lane != null) {
            presentFlags |= 8;
        }
        if (this.tile != null) {
            presentFlags |= 0x10;
        }
        if (this.xpos != null) {
            presentFlags |= 0x20;
        }
        if (this.ypos != null) {
            presentFlags |= 0x40;
        }
        if (this.read != null) {
            presentFlags |= 0x80;
        }
        if (this.filterPassed != null) {
            presentFlags |= 0x100;
        }
        if (this.controlNumber != null) {
            presentFlags |= 0x200;
        }
        if (this.indexSequence != null) {
            presentFlags |= 0x400;
        }
        WritableUtils.writeVInt((DataOutput)out, (int)presentFlags);
        if (this.instrument != null) {
            WritableUtils.writeString((DataOutput)out, (String)this.instrument);
        }
        if (this.runNumber != null) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.runNumber);
        }
        if (this.flowcellId != null) {
            WritableUtils.writeString((DataOutput)out, (String)this.flowcellId);
        }
        if (this.lane != null) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.lane);
        }
        if (this.tile != null) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.tile);
        }
        if (this.xpos != null) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.xpos);
        }
        if (this.ypos != null) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.ypos);
        }
        if (this.read != null) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.read);
        }
        if (this.filterPassed != null) {
            WritableUtils.writeVInt((DataOutput)out, (int)(this.filterPassed != false ? 1 : 0));
        }
        if (this.controlNumber != null) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.controlNumber);
        }
        if (this.indexSequence != null) {
            WritableUtils.writeString((DataOutput)out, (String)this.indexSequence);
        }
    }
}

