/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.seqdoop.hadoop_bam.VCFInputFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.seqdoop.hadoop_bam.util.MurmurHash3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCFRecordReader
extends RecordReader<LongWritable, VariantContextWritable> {
    private static final Logger logger = LoggerFactory.getLogger(VCFRecordReader.class);
    public static final String VALIDATION_STRINGENCY_PROPERTY = "hadoopbam.vcfrecordreader.validation-stringency";
    private final LongWritable key = new LongWritable();
    private final VariantContextWritable vc = new VariantContextWritable();
    private VCFCodec codec = new VCFCodec();
    private LineRecordReader lineRecordReader = new LineRecordReader();
    private VCFHeader header;
    private final Map<String, Integer> contigDict = new HashMap<String, Integer>();
    private List<Interval> intervals;
    private OverlapDetector<Interval> overlapDetector;
    private ValidationStringency stringency;

    static ValidationStringency getValidationStringency(Configuration conf) {
        String p = conf.get(VALIDATION_STRINGENCY_PROPERTY);
        return p == null ? ValidationStringency.STRICT : ValidationStringency.valueOf((String)p);
    }

    public static void setValidationStringency(Configuration conf, ValidationStringency stringency) {
        conf.set(VALIDATION_STRINGENCY_PROPERTY, stringency.toString());
    }

    public void initialize(InputSplit spl, TaskAttemptContext ctx) throws IOException {
        FileSplit split = (FileSplit)spl;
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(ctx.getConfiguration());
        try (FSDataInputStream ins = fs.open(file);){
            AsciiLineReader reader;
            CompressionCodec compressionCodec = new CompressionCodecFactory(ctx.getConfiguration()).getCodec(file);
            if (compressionCodec == null) {
                reader = new AsciiLineReader((InputStream)ins);
            } else {
                Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)compressionCodec);
                CompressionInputStream in = compressionCodec.createInputStream((InputStream)ins, decompressor);
                reader = new AsciiLineReader((InputStream)in);
            }
            AsciiLineReaderIterator it = new AsciiLineReaderIterator(reader);
            FeatureCodecHeader h = this.codec.readHeader((LineIterator)it);
            if (h == null || !(h.getHeaderValue() instanceof VCFHeader)) {
                throw new IOException("No VCF header found in " + file);
            }
            this.header = (VCFHeader)h.getHeaderValue();
            this.contigDict.clear();
            int i = 0;
            for (VCFContigHeaderLine contig : this.header.getContigLines()) {
                this.contigDict.put(contig.getID(), i++);
            }
        }
        this.lineRecordReader.initialize(spl, ctx);
        this.intervals = VCFInputFormat.getIntervals(ctx.getConfiguration());
        if (this.intervals != null) {
            this.overlapDetector = OverlapDetector.create(this.intervals);
        }
        this.stringency = VCFRecordReader.getValidationStringency(ctx.getConfiguration());
    }

    public void close() throws IOException {
        this.lineRecordReader.close();
    }

    public float getProgress() throws IOException {
        return this.lineRecordReader.getProgress();
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public VariantContextWritable getCurrentValue() {
        return this.vc;
    }

    public boolean nextKeyValue() throws IOException {
        VariantContext v;
        while (true) {
            if (!this.lineRecordReader.nextKeyValue()) {
                return false;
            }
            String line = this.lineRecordReader.getCurrentValue().toString();
            if (line.startsWith("#")) continue;
            try {
                v = this.codec.decode(line);
            }
            catch (TribbleException e) {
                if (this.stringency == ValidationStringency.STRICT) {
                    if (logger.isErrorEnabled()) {
                        logger.error("Parsing line {} failed with {}.", (Object)line, (Object)e);
                    }
                    throw e;
                }
                if (this.stringency != ValidationStringency.LENIENT || !logger.isWarnEnabled()) continue;
                logger.warn("Parsing line {} failed with {}. Skipping...", (Object)line, (Object)e);
                continue;
            }
            if (this.overlaps(v)) break;
        }
        Integer chromIdx = this.contigDict.get(v.getContig());
        if (chromIdx == null) {
            chromIdx = (int)MurmurHash3.murmurhash3(v.getContig(), 0);
        }
        this.key.set((long)chromIdx.intValue() << 32 | (long)(v.getStart() - 1));
        this.vc.set(v, this.header);
        return true;
    }

    private boolean overlaps(VariantContext v) {
        if (this.intervals == null) {
            return true;
        }
        Interval interval = new Interval(v.getContig(), v.getStart(), v.getEnd());
        return this.overlapDetector.overlapsAny((Locatable)interval);
    }
}

