/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.util.BGZFBlockIndex;
import org.seqdoop.hadoop_bam.util.BGZFSplitGuesser;

public abstract class BGZFSplitFileInputFormat<K, V>
extends FileInputFormat<K, V> {
    private Path getIdxPath(Path path) {
        return path.suffix(".bgzfi");
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List splits = super.getSplits(job);
        Collections.sort(splits, new Comparator<InputSplit>(){

            @Override
            public int compare(InputSplit a, InputSplit b) {
                FileSplit fa = (FileSplit)a;
                FileSplit fb = (FileSplit)b;
                return fa.getPath().compareTo((Object)fb.getPath());
            }
        });
        ArrayList<InputSplit> newSplits = new ArrayList<InputSplit>(splits.size());
        Configuration cfg = job.getConfiguration();
        int i = 0;
        while (i < splits.size()) {
            try {
                i = this.addIndexedSplits(splits, i, newSplits, cfg);
            }
            catch (IOException e) {
                i = this.addProbabilisticSplits(splits, i, newSplits, cfg);
            }
        }
        return newSplits;
    }

    private int addIndexedSplits(List<InputSplit> splits, int i, List<InputSplit> newSplits, Configuration cfg) throws IOException {
        int j;
        Path file = ((FileSplit)splits.get(i)).getPath();
        BGZFBlockIndex idx = new BGZFBlockIndex((InputStream)file.getFileSystem(cfg).open(this.getIdxPath(file)));
        int splitsEnd = splits.size();
        for (j = i; j < splitsEnd; ++j) {
            if (file.equals((Object)((FileSplit)splits.get(j)).getPath())) continue;
            splitsEnd = j;
        }
        for (j = i; j < splitsEnd; ++j) {
            Long blockEnd;
            FileSplit fileSplit = (FileSplit)splits.get(j);
            long start = fileSplit.getStart();
            long end = start + fileSplit.getLength();
            Long blockStart = idx.prevBlock(start);
            Long l = blockEnd = j == splitsEnd - 1 ? idx.prevBlock(end) : idx.nextBlock(end);
            if (blockStart == null) {
                throw new RuntimeException("Internal error or invalid index: no block start for " + start);
            }
            if (blockEnd == null) {
                throw new RuntimeException("Internal error or invalid index: no block end for " + end);
            }
            newSplits.add((InputSplit)new FileSplit(file, blockStart.longValue(), blockEnd - blockStart, fileSplit.getLocations()));
        }
        return splitsEnd;
    }

    private int addProbabilisticSplits(List<InputSplit> splits, int i, List<InputSplit> newSplits, Configuration cfg) throws IOException {
        FileSplit fspl;
        Path path = ((FileSplit)splits.get(i)).getPath();
        FSDataInputStream in = path.getFileSystem(cfg).open(path);
        BGZFSplitGuesser guesser = new BGZFSplitGuesser(in);
        do {
            fspl = (FileSplit)splits.get(i);
            long beg = fspl.getStart();
            long end = beg + fspl.getLength();
            long alignedBeg = guesser.guessNextBGZFBlockStart(beg, end);
            newSplits.add((InputSplit)new FileSplit(path, alignedBeg, end - alignedBeg, fspl.getLocations()));
        } while (++i < splits.size() && fspl.getPath().equals((Object)path));
        in.close();
        return i;
    }

    public boolean isSplitable(JobContext job, Path path) {
        return true;
    }
}

