/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;

public class EnhancedBloomFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double FALSE_POSITIVE_PROBABILITY_DEFAULT = 0.03;
    private final BloomFilter<String> bf;
    private int addedNumberOfElements;
    private final int expectedNumberOfElements;
    private final double falsePositiveProbability;

    public void put(String element) {
        this.bf.put((Object)element);
        ++this.addedNumberOfElements;
    }

    public boolean mightContain(String element) {
        return this.bf.mightContain((Object)element);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EnhancedBloomFilter deserializationBloomFilter(File fileSer) throws IOException {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fileSer));){
            EnhancedBloomFilter enhancedBloomFilter = (EnhancedBloomFilter)ois.readObject();
            return enhancedBloomFilter;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Cannot deserialize file: " + fileSer, e);
        }
    }

    public static void serializationBloomFilter(File fileSer, EnhancedBloomFilter bloomFilter) throws IOException {
        if (bloomFilter == null) {
            throw new IOException("Bloom filter not exists");
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileSer));
            oos.writeObject(bloomFilter);
            oos.flush();
            oos.close();
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cannot serialize file: " + fileSer, e);
        }
    }

    public boolean sameConfigurationFilter(EnhancedBloomFilter that) {
        return this.getExpectedNumberOfElements() == that.getExpectedNumberOfElements() && this.getFalsePositiveProbability() == that.getFalsePositiveProbability();
    }

    public BloomFilter<String> getBf() {
        return this.bf;
    }

    public int getAddedNumberOfElements() {
        return this.addedNumberOfElements;
    }

    public int getExpectedNumberOfElements() {
        return this.expectedNumberOfElements;
    }

    public double getFalsePositiveProbability() {
        return this.falsePositiveProbability;
    }

    public String toString() {
        return "Bloom filter features\n\tfalse positive probability " + this.getFalsePositiveProbability() + "%\n\tnumber elements expected " + this.getExpectedNumberOfElements() + "\n\tnumber elements added " + this.getAddedNumberOfElements();
    }

    public EnhancedBloomFilter(int expectedNumberOfElements) {
        this(expectedNumberOfElements, 0.03);
    }

    public EnhancedBloomFilter(int expectedNumberOfElements, double falsePositiveProbability) {
        if (expectedNumberOfElements <= 0) {
            throw new IllegalArgumentException("Parameter 'expectedNumberOfElements' to create bloom filter invalid " + expectedNumberOfElements);
        }
        if (falsePositiveProbability <= 0.0 || falsePositiveProbability >= 1.0) {
            throw new IllegalArgumentException("Parameter 'falsePositiveProbability' to create bloom filter invalid " + falsePositiveProbability);
        }
        this.addedNumberOfElements = 0;
        this.expectedNumberOfElements = expectedNumberOfElements;
        this.falsePositiveProbability = falsePositiveProbability;
        this.bf = BloomFilter.create((Funnel)new Funnel<String>(){
            private static final long serialVersionUID = 1L;

            public void funnel(String from, PrimitiveSink into) {
                into.putString((CharSequence)from, StandardCharsets.UTF_8);
            }
        }, (int)expectedNumberOfElements, (double)falsePositiveProbability);
    }

    public EnhancedBloomFilter(BloomFilter<String> bf, int addedNumberOfElements, int expectedNumberOfElements, double falsePositiveProbability) {
        if (bf == null) {
            throw new NullPointerException("bf argument cannot be null");
        }
        this.bf = bf.copy();
        this.addedNumberOfElements = addedNumberOfElements;
        this.expectedNumberOfElements = expectedNumberOfElements;
        this.falsePositiveProbability = falsePositiveProbability;
    }
}

