/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it;

import com.google.common.base.Stopwatch;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.it.ITCommandResult;
import fr.ens.biologie.genomique.kenetre.it.ITLogger;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class ITCommandExecutor {
    private static final String STDERR_FILENAME = "STDERR";
    private static final String STDOUT_FILENAME = "STDOUT";
    private static final String CMDLINE_FILENAME = "CMDLINE";
    private final Properties testConf;
    private final File outputTestDirectory;
    private final int durationMax;
    private final File cmdLineFile;
    private final String[] environmentVariables;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITCommandResult executeCommand(String scriptConfKey, String suffixNameOutputFile, String desc, boolean isApplicationCmdLine) {
        if (this.testConf.getProperty(scriptConfKey) == null) {
            return null;
        }
        String cmdLine = this.testConf.getProperty(scriptConfKey);
        if (cmdLine.isEmpty()) {
            return null;
        }
        if (isApplicationCmdLine) {
            try {
                Files.write(this.cmdLineFile.toPath(), Collections.singleton(cmdLine), new OpenOption[0]);
            }
            catch (IOException e) {
                ITLogger.getLogger().warning("Error while writing the application command line in file: " + e.getMessage());
            }
        }
        File stdoutFile = this.createSdtoutFile(suffixNameOutputFile);
        File stderrFile = this.createSdterrFile(suffixNameOutputFile);
        int exitValue = -1;
        Stopwatch timer = Stopwatch.createStarted();
        ITCommandResult cmdResult = new ITCommandResult(cmdLine, this.outputTestDirectory, desc, this.durationMax);
        try {
            Process p = Runtime.getRuntime().exec(cmdLine, this.environmentVariables, this.outputTestDirectory);
            MonitorThread monitor = new MonitorThread(p, desc, this.durationMax);
            if (stdoutFile != null) {
                new CopyProcessOutput(p.getInputStream(), stdoutFile, "stdout").start();
            }
            if (stderrFile != null) {
                new CopyProcessOutput(p.getErrorStream(), stderrFile, "stderr").start();
            }
            exitValue = p.waitFor();
            monitor.interrupt();
            cmdResult.setExitValue(exitValue);
            if (exitValue != 0) {
                if (monitor.isKilledProcess()) {
                    cmdResult.asInterruptedProcess();
                    cmdResult.setException((Exception)new KenetreException("\tKill process.\n\tCommand line: " + cmdLine + "\n\tDirectory: " + this.outputTestDirectory + "\n\tMessage: " + monitor.getMessage()));
                } else {
                    cmdResult.setException((Exception)new KenetreException("\tCommand line: " + cmdLine + "\n\tDirectory: " + this.outputTestDirectory + "\n\tMessage: bad exit value: " + exitValue));
                    cmdResult.setErrorFileOnProcess(stderrFile);
                }
            } else if (exitValue == 0 && !isApplicationCmdLine) {
                if (!stdoutFile.delete()) {
                    ITLogger.getLogger().warning("Unable to deleted stdout file: " + stdoutFile);
                }
                if (!stderrFile.delete()) {
                    ITLogger.getLogger().warning("Unable to deleted stderr file: " + stdoutFile);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            cmdResult.setException(e, "\tError before execution.\n\tCommand line: " + cmdLine + "\n\tDirectory: " + this.outputTestDirectory + "\n\tMessage: " + e.getMessage());
        }
        finally {
            cmdResult.setDuration(timer.elapsed(TimeUnit.MILLISECONDS));
            timer.stop();
        }
        return cmdResult;
    }

    private File createSdtoutFile(String suffixName) {
        return new File(this.outputTestDirectory, STDOUT_FILENAME + (suffixName.isEmpty() ? "" : "_" + suffixName));
    }

    private File createSdterrFile(String suffixName) {
        return new File(this.outputTestDirectory, STDERR_FILENAME + (suffixName.isEmpty() ? "" : "_" + suffixName));
    }

    public ITCommandExecutor(Properties testConf, File outputTestDirectory, List<String> environmentVariables, int durationMax) {
        this.testConf = testConf;
        this.outputTestDirectory = outputTestDirectory;
        this.environmentVariables = environmentVariables.toArray(new String[0]);
        this.cmdLineFile = new File(this.outputTestDirectory, CMDLINE_FILENAME);
        this.durationMax = durationMax;
    }

    private static final class MonitorThread
    extends Thread {
        private final Process p;
        private int pid = -1;
        private final int durationMaxInMinutes;
        private final String desc;
        private boolean killedProcess = false;
        private boolean killByCmd = false;
        private boolean killByMethodDestroy = false;

        @Override
        public void run() {
        }

        void destroyProcessScript() {
        }

        int getPID() {
            try {
                Field f = this.p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                return (Integer)f.get(this.p);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return -1;
            }
        }

        public boolean isKilledProcess() {
            return this.killedProcess;
        }

        public String getMessage() {
            return "script process on " + this.desc + " with pid " + this.pid + " has been killed " + (this.killByCmd ? "by command kill -TERM" : (this.killByMethodDestroy ? "by method process.destroy" : "other mean")) + " after " + StringUtils.toTimeHumanReadable((long)(this.durationMaxInMinutes * 60 * 1000));
        }

        public MonitorThread(Process processScript, String desc, int durationMaxInMinutes) {
            this.p = processScript;
            this.desc = desc;
            this.durationMaxInMinutes = durationMaxInMinutes;
            this.pid = this.getPID();
            this.start();
        }
    }

    private static final class CopyProcessOutput
    extends Thread {
        private final Path path;
        private final InputStream in;
        private final String desc;

        @Override
        public void run() {
            try {
                Files.copy(this.in, this.path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                ITLogger.getLogger().warning("Error while copying " + this.desc + ": " + e.getMessage());
            }
        }

        CopyProcessOutput(InputStream in, File file, String desc) {
            Objects.requireNonNull(in, "in argument cannot be null");
            Objects.requireNonNull(file, "file argument cannot be null");
            Objects.requireNonNull(desc, "desc argument cannot be null");
            this.in = in;
            this.path = file.toPath();
            this.desc = desc;
        }
    }
}

