/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it;

import com.google.common.io.Files;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.it.IT;
import fr.ens.biologie.genomique.kenetre.it.ITSuite;
import fr.ens.biologie.genomique.kenetre.util.process.ProcessUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.compress.utils.Charsets;
import org.testng.annotations.Factory;

public class ITFactory {
    public static final String IT_CONF_PATH_SYSTEM_KEY = "it.conf.path";
    public static final String IT_TEST_LIST_PATH_SYSTEM_KEY = "it.test.list.path";
    public static final String IT_TEST_SYSTEM_KEY = "it.test.name";
    public static final String IT_GENERATE_ALL_EXPECTED_DATA_SYSTEM_KEY = "it.generate.all.expected.data";
    public static final String IT_GENERATE_NEW_EXPECTED_DATA_SYSTEM_KEY = "it.generate.new.expected.data";
    public static final String IT_APPLICATION_PATH_KEY_SYSTEM_KEY = "it.application.path";
    public static final String IT_DEBUG_ENABLE_SYSTEM_KEY = "it.debug.enable";
    public static final String IT_OUTPUT_DIR_SYSTEM_KEY = "it.output.dir";
    static final String TESTS_DIRECTORY_CONF_KEY = "tests.directory";
    static final String OUTPUT_ANALYSIS_DIRECTORY_CONF_KEY = "output.analysis.directory";
    static final String LOG_DIRECTORY_CONF_KEY = "log.directory";
    static final String PRE_TEST_SCRIPT_CONF_KEY = "pre.test.script";
    static final String POST_TEST_SCRIPT_CONF_KEY = "post.test.script";
    static final String GENERATE_ALL_EXPECTED_DATA_CONF_KEY = "generate.all.expected.data";
    static final String GENERATE_NEW_EXPECTED_DATA_CONF_KEY = "generate.new.expected.data";
    static final String DESCRIPTION_CONF_KEY = "description";
    static final String COMMAND_TO_LAUNCH_APPLICATION_CONF_KEY = "command.to.launch.application";
    static final String COMMAND_TO_GENERATE_MANUALLY_CONF_KEY = "command.to.generate.manually";
    static final String COMMAND_TO_GET_APPLICATION_VERSION_CONF_KEY = "command.to.get.application.version";
    static final String INCLUDE_CONF_KEY = "include";
    static final String SUCCESS_IT_DELETE_FILE_CONF_KEY = "success.it.delete.file";
    private static final String SUCCESS_IT_DELETE_FILE_DEFAULT_VALUE = "false";
    static final String FILE_TO_COMPARE_PATTERNS_CONF_KEY = "files.to.compare";
    static final String EXCLUDE_TO_COMPARE_PATTERNS_CONF_KEY = "excluded.files.to.compare";
    static final String CHECK_LENGTH_FILE_PATTERNS_CONF_KEY = "files.to.check.length";
    static final String CHECK_EXISTENCE_FILE_PATTERNS_CONF_KEY = "files.to.check.existences";
    static final String CHECK_ABSENCE_FILE_PATTERNS_CONF_KEY = "files.to.check.absence";
    static final String FILE_TO_REMOVE_CONF_KEY = "files.to.remove";
    static final String MANUAL_GENERATION_EXPECTED_DATA_CONF_KEY = "manual.generation.expected.data";
    static final String RUNTIME_IT_MAXIMUM_KEY = "runtime.test.maximum";
    static final String PRETREATMENT_GLOBAL_SCRIPT_KEY = "pre.global.script";
    static final String POSTTREATMENT_GLOBAL_SCRIPT_KEY = "post.global.script";
    static final String APPLICATION_PATH_VARIABLE = "application.path";
    static final String TEST_CONFIGURATION_FILENAME = "test.conf";
    static final int RUNTIME_IT_MAXIMUM_DEFAULT = 1;
    private static final Properties CONSTANTS = ITFactory.initConstants();
    private final Properties globalsConf;
    private final File applicationPath;
    private final File selectedTestsFile;
    private final String selectedTest;
    private final File testsDataDirectory;
    private final Map<String, File> testsDirectoryFoundToExecute;

    @Factory
    public final Object[] createInstances() {
        if (this.applicationPath == null) {
            return new Object[0];
        }
        Locale.setDefault(IT.DEFAULT_LOCALE);
        try {
            int testsCount = ITSuite.getInstance().getCountTest();
            if (testsCount == 0) {
                return new Object[0];
            }
            return ITSuite.getInstance().getTestsInstanceToArray();
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            return new Object[0];
        }
    }

    private Map<String, File> collectTestsDirectoryToExecute() throws KenetreException, IOException {
        File[] files;
        HashMap<String, File> result = new HashMap<String, File>();
        ArrayList<File> testsToExecuteDirectories = new ArrayList<File>(this.readTestListFile());
        if (this.selectedTest != null) {
            testsToExecuteDirectories.add(new File(this.testsDataDirectory, this.selectedTest));
        }
        if ((files = this.testsDataDirectory.listFiles()) != null && testsToExecuteDirectories.isEmpty()) {
            testsToExecuteDirectories.addAll(Arrays.asList(files));
        }
        if (testsToExecuteDirectories.size() == 0) {
            throw new KenetreException("None test directory found in " + this.testsDataDirectory.getAbsolutePath());
        }
        for (File testDirectory : testsToExecuteDirectories) {
            if (testDirectory.isFile()) continue;
            FileUtils.checkExistingDirectoryFile((File)testDirectory, (String)"test directory");
            if (!new File(testDirectory, TEST_CONFIGURATION_FILENAME).exists()) continue;
            result.put(testDirectory.getName(), testDirectory);
        }
        return Collections.unmodifiableMap(result);
    }

    private List<File> readTestListFile() throws IOException {
        String nameTest;
        ArrayList<File> result = new ArrayList<File>();
        if (this.selectedTestsFile == null) {
            return Collections.emptyList();
        }
        FileUtils.checkExistingStandardFile((File)this.selectedTestsFile, (String)"selected tests file");
        BufferedReader br = new BufferedReader(Files.newReader((File)this.selectedTestsFile, (Charset)Charsets.toCharset((Charset)Charset.defaultCharset())));
        while ((nameTest = br.readLine()) != null) {
            if (nameTest.startsWith("#") || nameTest.isEmpty()) continue;
            result.add(new File(this.testsDataDirectory, nameTest.trim()));
        }
        br.close();
        return result;
    }

    private static Properties initConstants() {
        Properties constants = new Properties();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            constants.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : System.getenv().entrySet()) {
            constants.put(entry.getKey(), entry.getValue());
        }
        return constants;
    }

    private static Properties loadProperties(File configurationFile) throws IOException, KenetreException {
        Properties rawProps = new Properties();
        FileUtils.checkExistingStandardFile((File)configurationFile, (String)"test configuration file");
        rawProps.load(Files.newReader((File)configurationFile, (Charset)Charsets.toCharset((Charset)Charset.defaultCharset())));
        Properties props = ITFactory.evaluateProperties(rawProps);
        String includeOption = props.getProperty(INCLUDE_CONF_KEY);
        if (includeOption != null) {
            File otherConfigurationFile = new File(includeOption);
            FileUtils.checkExistingStandardFile((File)otherConfigurationFile, (String)"configuration file doesn't exist");
            Properties rawPropsIncludedConfigurationFile = new Properties();
            rawPropsIncludedConfigurationFile.load(Files.newReader((File)otherConfigurationFile, (Charset)Charsets.toCharset((Charset)Charset.defaultCharset())));
            Properties newProps = ITFactory.evaluateProperties(rawPropsIncludedConfigurationFile);
            for (String propertyName : newProps.stringPropertyNames()) {
                if (props.containsKey(propertyName)) continue;
                props.put(propertyName, newProps.getProperty(propertyName));
            }
        }
        ITFactory.addDefaultProperties(props);
        return props;
    }

    private static void addDefaultProperties(Properties props) {
        if (props.getProperty(SUCCESS_IT_DELETE_FILE_CONF_KEY) == null) {
            props.put(SUCCESS_IT_DELETE_FILE_CONF_KEY, SUCCESS_IT_DELETE_FILE_DEFAULT_VALUE);
        }
        if (props.getProperty(RUNTIME_IT_MAXIMUM_KEY) == null) {
            props.put(RUNTIME_IT_MAXIMUM_KEY, "1");
        }
    }

    private static Properties evaluateProperties(Properties rawProps) throws KenetreException {
        Properties props = new Properties();
        int pos = "env.var.".length();
        for (String propertyName : rawProps.stringPropertyNames()) {
            if (!propertyName.startsWith("env.var.")) continue;
            String evalPropValue = ITFactory.evaluateExpressions(rawProps.getProperty(propertyName), true);
            CONSTANTS.put(propertyName.substring(pos), evalPropValue);
        }
        for (String propertyName : rawProps.stringPropertyNames()) {
            String propertyValue = ITFactory.evaluateExpressions(rawProps.getProperty(propertyName), true);
            props.setProperty(propertyName, propertyValue);
        }
        return props;
    }

    static String evaluateExpressions(String s, boolean allowExec) throws KenetreException {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c1;
            int c0 = s.codePointAt(i);
            if (c0 == 36 && i + 1 < len && (c1 = s.codePointAt(i + 1)) == 123) {
                String expr = ITFactory.subStr(s, i + 2, 125);
                String trimmedExpr = expr.trim();
                if (CONSTANTS.containsKey(trimmedExpr)) {
                    result.append(CONSTANTS.get(trimmedExpr));
                }
                i += expr.length() + 2;
                continue;
            }
            if (c0 == 96 && allowExec) {
                String expr = ITFactory.subStr(s, i + 1, 96);
                try {
                    String r = ProcessUtils.execToString((String)ITFactory.evaluateExpressions(expr, false));
                    if (!r.isEmpty() && r.charAt(r.length() - 1) == '\n') {
                        result.append(r, 0, r.length() - 1);
                    } else {
                        result.append(r);
                    }
                }
                catch (IOException e) {
                    throw new KenetreException("Error while evaluating expression \"" + expr + "\"", (Throwable)e);
                }
                i += expr.length() + 1;
                continue;
            }
            result.appendCodePoint(c0);
        }
        return result.toString();
    }

    private static String subStr(String s, int beginIndex, int charPoint) throws KenetreException {
        int endIndex = s.indexOf(charPoint, beginIndex);
        if (endIndex == -1) {
            throw new KenetreException("Unexpected end of expression in \"" + s + "\"");
        }
        return s.substring(beginIndex, endIndex);
    }

    private void addParameterCommandLineInConfiguration() throws KenetreException, IOException {
        if (this.globalsConf == null) {
            throw new KenetreException("Configuration file from integrated test has not be loaded. Can not add parameter command line.");
        }
        this.globalsConf.setProperty(GENERATE_ALL_EXPECTED_DATA_CONF_KEY, ITFactory.getBooleanFromSystemProperty(IT_GENERATE_ALL_EXPECTED_DATA_SYSTEM_KEY).toString());
        this.globalsConf.setProperty(GENERATE_NEW_EXPECTED_DATA_CONF_KEY, ITFactory.getBooleanFromSystemProperty(IT_GENERATE_NEW_EXPECTED_DATA_SYSTEM_KEY).toString());
        File itOutputDirectoryFromCommandLine = ITFactory.getFileFromSystemProperty(IT_OUTPUT_DIR_SYSTEM_KEY);
        if (itOutputDirectoryFromCommandLine != null) {
            this.checkDirectoryFileAndCreateIfNotExist(itOutputDirectoryFromCommandLine);
            this.globalsConf.put(OUTPUT_ANALYSIS_DIRECTORY_CONF_KEY, itOutputDirectoryFromCommandLine.getAbsolutePath());
        }
    }

    private void checkDirectoryFileAndCreateIfNotExist(File dir) throws KenetreException, IOException {
        if (dir.isDirectory()) {
            return;
        }
        if (dir.exists() && dir.isFile()) {
            throw new KenetreException("The it output directory is a file not a directory " + dir.getAbsolutePath());
        }
        File parentDir = dir.getParentFile();
        if (!parentDir.isDirectory()) {
            throw new KenetreException("Can not create it output directory (" + dir.getName() + "), parent directory doesn't exist " + parentDir.getAbsolutePath());
        }
        if (!dir.mkdir()) {
            throw new IOException("Fail to create it output directory set in command line " + dir.getAbsolutePath());
        }
    }

    private static File getFileFromSystemProperty(String property) {
        if (property == null) {
            return null;
        }
        String value = System.getProperty(property);
        if (value == null) {
            return null;
        }
        return new File(value);
    }

    private static Boolean getBooleanFromSystemProperty(String property) {
        return property != null && Boolean.getBoolean(property);
    }

    private static File getApplicationPath() {
        File dir = ITFactory.getFileFromSystemProperty(IT_APPLICATION_PATH_KEY_SYSTEM_KEY);
        if (dir != null) {
            return dir;
        }
        File distDir = new File(System.getProperty("user.dir") + File.separator + "target" + File.separator + "dist");
        if (!distDir.isDirectory()) {
            return null;
        }
        System.setProperty("maven.testng.output.dir", "");
        File subDir = null;
        int dirCount = 0;
        int fileCount = 0;
        File[] files = distDir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.getName().startsWith(".")) continue;
                if (f.isDirectory()) {
                    ++dirCount;
                    subDir = f;
                    continue;
                }
                if (!f.isFile()) continue;
                ++fileCount;
            }
        }
        if (fileCount == 0 && dirCount == 1) {
            return subDir;
        }
        return distDir;
    }

    public ITFactory() throws KenetreException, IOException {
        File configurationFile = ITFactory.getFileFromSystemProperty(IT_CONF_PATH_SYSTEM_KEY);
        if (configurationFile != null) {
            this.applicationPath = ITFactory.getApplicationPath();
            CONSTANTS.setProperty(APPLICATION_PATH_VARIABLE, this.applicationPath.getAbsolutePath());
            FileUtils.checkExistingDirectoryFile((File)this.applicationPath, (String)"application path");
            this.selectedTestsFile = ITFactory.getFileFromSystemProperty(IT_TEST_LIST_PATH_SYSTEM_KEY);
            this.selectedTest = System.getProperty(IT_TEST_SYSTEM_KEY);
            this.globalsConf = ITFactory.loadProperties(configurationFile);
            this.addParameterCommandLineInConfiguration();
            this.testsDataDirectory = new File(this.globalsConf.getProperty(TESTS_DIRECTORY_CONF_KEY));
            this.testsDirectoryFoundToExecute = this.collectTestsDirectoryToExecute();
            ITSuite.getInstance(this.testsDirectoryFoundToExecute, this.globalsConf, this.applicationPath);
        } else {
            this.applicationPath = null;
            this.testsDataDirectory = null;
            this.selectedTestsFile = null;
            this.selectedTest = null;
            this.globalsConf = null;
            this.testsDirectoryFoundToExecute = null;
        }
    }
}

