/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it;

import fr.ens.biologie.genomique.kenetre.it.IT;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ITLogger {
    public static final Formatter LOG_FORMATTER = new Formatter(){
        private final DateFormat df = new SimpleDateFormat("yyyy.MM.dd kk:mm:ss", IT.DEFAULT_LOCALE);

        @Override
        public String format(LogRecord record) {
            return record.getLevel() + "\t" + this.df.format(new Date(record.getMillis())) + "\t" + record.getMessage() + "\n";
        }
    };

    public static Logger getLogger() {
        return Logger.getLogger("itlogger");
    }

    public static void initLogger(String loggerPath) throws IOException {
        ITLogger.getLogger().setLevel(Level.OFF);
        ITLogger.getLogger().removeHandler(ITLogger.getLogger().getParent().getHandlers()[0]);
        FileHandler fh = null;
        try {
            fh = new FileHandler(loggerPath);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        fh.setFormatter(LOG_FORMATTER);
        ITLogger.getLogger().setLevel(Level.ALL);
        ITLogger.getLogger().setUseParentHandlers(false);
        ITLogger.getLogger().addHandler(fh);
    }
}

