/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it;

import fr.ens.biologie.genomique.kenetre.it.IT;
import java.io.File;

final class ITOutputComparisonResult
implements Comparable<ITOutputComparisonResult> {
    private static final String TYPE_FAIL = "FAIL";
    private static final String TYPE_OK = "OK";
    private String filename;
    private StatusComparison statusComparison = StatusComparison.TO_COMPARE;
    private String message = "none";
    private String fileTestedPath;
    private String fileExpectedPath;

    public String getReport() {
        StringBuilder txt = new StringBuilder();
        txt.append("\t").append(this.statusComparison.getType()).append(" : ");
        txt.append(this.filename);
        if (this.statusComparison.getType().equals(TYPE_FAIL)) {
            txt.append(" ");
            txt.append(this.statusComparison.getName());
            txt.append("\n\t\tOutput file: ");
            txt.append(this.fileTestedPath);
            txt.append("\n\t\tExpected file: ");
            txt.append(this.fileExpectedPath);
            txt.append("\n\t\tError message: ");
            txt.append(this.message);
        }
        return txt.toString();
    }

    public void setResult(StatusComparison statusComparison, String message) {
        this.setResult(statusComparison, null, null, message);
    }

    public void setResult(StatusComparison statusComparison) {
        this.setResult(statusComparison, null, null, "");
    }

    public void setResult(StatusComparison status, File fileExpected, File fileTested, String msg) {
        this.setStatusComparison(status);
        this.setMessage(msg);
        this.fileExpectedPath = fileExpected == null ? "none" : fileExpected.getAbsolutePath();
        this.fileTestedPath = fileTested == null ? "none" : fileTested.getAbsolutePath();
    }

    @Override
    public int compareTo(ITOutputComparisonResult that) {
        return this.filename.compareTo(that.filename);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.statusComparison == null ? 0 : this.statusComparison.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ITOutputComparisonResult other = (ITOutputComparisonResult)obj;
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.statusComparison == other.statusComparison;
    }

    public String getFilename() {
        return this.filename;
    }

    public StatusComparison getStatusComparison() {
        return this.statusComparison;
    }

    public String getMessage() {
        return this.message;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setStatusComparison(StatusComparison statusComparison) {
        this.statusComparison = statusComparison;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ITOutputComparisonResult(String filename, StatusComparison statusComparison, String message) {
        this.filename = filename;
        this.message = message;
        this.statusComparison = statusComparison;
    }

    public ITOutputComparisonResult(String filename) {
        this.filename = filename;
    }

    static enum StatusComparison {
        NOT_EQUALS("not equals", false, "Comparison failed for output result file: "),
        EQUALS("equals", true, ""),
        UNEXPECTED("unexpected", false, "Found unexpected file in result test directory: "),
        MISSING("missing", false, "Missing expected file in result test directory: "),
        TO_COMPARE("to compare", false, "Not comparison start.");

        private final String name;
        private final String exceptionMessage;
        private final boolean isSuccess;

        public String getName() {
            return this.name.toUpperCase(IT.DEFAULT_LOCALE);
        }

        public String getType() {
            return this.isSuccess() ? ITOutputComparisonResult.TYPE_OK : ITOutputComparisonResult.TYPE_FAIL;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public String getExceptionMessage() {
            return this.exceptionMessage;
        }

        private StatusComparison(String name, boolean isSuccess, String exceptionMessage) {
            this.name = name;
            this.isSuccess = isSuccess;
            this.exceptionMessage = exceptionMessage;
        }
    }
}

