/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it;

import com.google.common.base.Stopwatch;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.KenetreRuntimeException;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.it.IT;
import fr.ens.biologie.genomique.kenetre.it.ITLogger;
import fr.ens.biologie.genomique.kenetre.it.ITResult;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.process.ProcessUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;

public class ITSuite {
    private static final String RUNNING_LINK_NAME = "running";
    private static final String SUCCEEDED_LINK_NAME = "succeeded";
    private static final String FAILED_LINK_NAME = "failed";
    private static final String LATEST_LINK_NAME = "latest";
    private static final Formatter DATE_FORMATTER = new Formatter().format(IT.DEFAULT_LOCALE, "%1$tY%1$tm%1$td_%1$tH%1$tM%1$tS", new Date());
    private static ITSuite itSuite;
    private final Stopwatch globalTimer = Stopwatch.createStarted();
    private final Properties globalsConf;
    private final File applicationPath;
    private final File outputTestsDirectory;
    private final int testsCount;
    private final Map<String, File> testsToExecute;
    private final List<IT> testsInstance;
    private boolean debugEnabled = false;
    private int failCount = 0;
    private int successCount = 0;
    private int testRunningCount = 0;
    private int testSkippingCount = 0;
    private boolean isFirstTest = true;
    private final String loggerPath;
    private final File testsDataDirectory;
    private final String versionApplication;
    private final boolean generateAllExpectedDirectoryTest;
    private final boolean generateNewExpectedDirectoryTests;
    private final String actionType;

    public static ITSuite getInstance(Map<String, File> tests, Properties globalsConf, File applicationPath) throws IOException, KenetreException {
        if (itSuite == null) {
            itSuite = new ITSuite(tests, globalsConf, applicationPath);
            return itSuite;
        }
        throw new KenetreRuntimeException("Cannot create an instance of ITSuite because an instance has already been created.");
    }

    public static ITSuite getInstance() {
        if (itSuite != null) {
            return itSuite;
        }
        throw new KenetreRuntimeException("Cannot get an instance of ITSuite class because no instance has been created.");
    }

    public static Path createRelativeOrAbsoluteSymbolicLink(Path linkPath, Path targetPath) throws IOException {
        if (linkPath == null) {
            throw new IOException("Can not be create relative symbolic link, link path is null.");
        }
        if (targetPath == null) {
            throw new IOException("Can not be create relative symbolic link, target path is null.");
        }
        Path basePath = linkPath.getParent();
        try {
            Path pathRelative = basePath.relativize(targetPath);
            return Files.createSymbolicLink(linkPath, pathRelative, new FileAttribute[0]);
        }
        catch (IllegalArgumentException e) {
            return Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
        }
    }

    public void notifyStartTest() {
        if (this.isFirstTest) {
            this.createSymbolicLinkToTest();
            this.isFirstTest = false;
        }
        ++this.testRunningCount;
    }

    public void notifyEndTest(ITResult itResult) {
        if (itResult.isNothingToDo()) {
            ++this.testSkippingCount;
        } else if (itResult.isSuccess()) {
            ++this.successCount;
        } else {
            ++this.failCount;
        }
        if (this.testRunningCount == this.testsCount) {
            this.createSymbolicLinkToTest();
            this.endLogger();
        }
    }

    public String retrieveVersionApplication(String commandLine, File applicationPath) {
        String version = "UNKNOWN";
        if (commandLine == null || commandLine.trim().length() == 0) {
            return version;
        }
        try {
            String output = ProcessUtils.execToString((String)commandLine);
            if (output != null && output.trim().length() > 0) {
                version = output.trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version;
    }

    private void createSymbolicLinkToTest() {
        this.removeOldLink(RUNNING_LINK_NAME);
        if (this.testRunningCount == 0) {
            this.createNewLink(RUNNING_LINK_NAME);
        } else {
            this.removeOldLinkAndCreateANewOne(LATEST_LINK_NAME);
            if (this.failCount == 0) {
                this.removeOldLinkAndCreateANewOne(SUCCEEDED_LINK_NAME);
            } else {
                this.removeOldLinkAndCreateANewOne(FAILED_LINK_NAME);
            }
        }
    }

    private void removeOldLinkAndCreateANewOne(String linkName) {
        this.removeOldLink(linkName);
        this.createNewLink(linkName);
    }

    private void removeOldLink(String linkName) {
        Path outputTestsPath = this.outputTestsDirectory.getParentFile().toPath();
        Path linkPath = new File(outputTestsPath.toFile(), linkName).toPath();
        try {
            Files.delete(linkPath);
        }
        catch (IOException e) {
            ITLogger.getLogger().warning("Unable to delete old " + linkName + " directory link: " + linkPath);
        }
    }

    private void createNewLink(String linkName) {
        Path outputTestsPath = this.outputTestsDirectory.getParentFile().toPath();
        Path linkPath = new File(outputTestsPath.toFile(), linkName).toPath();
        try {
            ITSuite.createRelativeOrAbsoluteSymbolicLink(linkPath, this.outputTestsDirectory.toPath());
        }
        catch (IOException e) {
            ITLogger.getLogger().warning("Unable to create " + linkName + " directory link: " + linkPath);
        }
    }

    private Map<String, File> checkValidateTest(Map<String, File> tests) throws KenetreException {
        HashMap<String, File> validTests = new HashMap<String, File>();
        for (Map.Entry<String, File> entry : tests.entrySet()) {
            if (!new File(entry.getValue(), "test.conf").exists()) continue;
            validTests.put(entry.getKey(), entry.getValue());
        }
        if (validTests.isEmpty()) {
            throw new KenetreException("None test valide in directory " + this.testsDataDirectory.getAbsolutePath());
        }
        return Collections.unmodifiableMap(validTests);
    }

    private List<IT> initIT() throws IOException, KenetreException {
        ArrayList<IT> tests = new ArrayList<IT>();
        TreeSet<String> testsName = new TreeSet<String>(this.testsToExecute.keySet());
        for (String testName : testsName) {
            IT processIT = new IT(this, this.globalsConf, this.applicationPath, this.testsDataDirectory, this.outputTestsDirectory, testName);
            tests.add(processIT);
        }
        if (tests.isEmpty()) {
            throw new KenetreException("None integration test instance create.");
        }
        return Collections.unmodifiableList(tests);
    }

    private void init() throws IOException {
        ITLogger.initLogger(this.loggerPath);
        FileUtils.checkExistingDirectoryFile((File)this.testsDataDirectory, (String)"tests data directory");
        ITLogger.getLogger().config("Tests data directory: " + this.testsDataDirectory.getAbsolutePath());
        FileUtils.checkExistingDirectoryFile((File)this.outputTestsDirectory.getParentFile(), (String)"output data parent directory");
        ITLogger.getLogger().config("Output tests directory: " + this.outputTestsDirectory.getAbsolutePath());
        if (!this.outputTestsDirectory.mkdir()) {
            throw new IOException("Cannot create output tests directory " + this.outputTestsDirectory.getAbsolutePath());
        }
        ITLogger.getLogger().config("Action " + this.actionType);
        File loggerFile = new File(this.loggerPath);
        if (loggerFile.exists()) {
            Files.createSymbolicLink(new File(this.outputTestsDirectory, loggerFile.getName()).toPath(), loggerFile.toPath(), new FileAttribute[0]);
        }
    }

    private void endLogger() {
        ITLogger.getLogger().info("End of execution for " + this.testRunningCount + " integration tests in " + StringUtils.toTimeHumanReadable((long)this.globalTimer.elapsed(TimeUnit.MILLISECONDS)));
        ITLogger.getLogger().info("RUN : " + this.successCount + " succeeded, " + this.failCount + " failed, " + this.testSkippingCount + " skipped. " + (this.failCount == 0 ? "All tests are OK." : ""));
        this.globalTimer.stop();
    }

    public boolean isDebugModeEnabled() {
        return this.debugEnabled;
    }

    public void setDebugModeEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public boolean isGenerateAllExpectedDirectoryTest() {
        return this.generateAllExpectedDirectoryTest;
    }

    public boolean isGenerateNewExpectedDirectoryTests() {
        return this.generateNewExpectedDirectoryTests;
    }

    public String getActionType() {
        return this.actionType;
    }

    public File getTestsDataDirectory() {
        return this.testsDataDirectory;
    }

    public Map<String, File> getTestsToExecute() {
        return this.testsToExecute;
    }

    public List<IT> getTestsInstance() {
        return this.testsInstance;
    }

    public Object[] getTestsInstanceToArray() {
        return this.testsInstance.toArray(new Object[this.testsCount]);
    }

    public int getCountTest() {
        return this.testsCount;
    }

    public String getOutputTestDirectoryPath() {
        return this.outputTestsDirectory.getAbsolutePath();
    }

    private ITSuite(Map<String, File> tests, Properties globalsConf, File applicationPath) throws IOException, KenetreException {
        FileUtils.checkExistingDirectoryFile((File)applicationPath, (String)"application path");
        this.globalsConf = globalsConf;
        this.applicationPath = applicationPath;
        this.testsDataDirectory = new File(this.globalsConf.getProperty("tests.directory"));
        this.versionApplication = this.retrieveVersionApplication(this.globalsConf.getProperty("command.to.get.application.version"), this.applicationPath);
        this.loggerPath = this.globalsConf.getProperty("log.directory") + "/" + this.versionApplication + "_" + DATE_FORMATTER.toString() + ".log";
        this.outputTestsDirectory = new File(this.globalsConf.getProperty("output.analysis.directory"), this.versionApplication + "_" + DATE_FORMATTER.toString());
        this.generateAllExpectedDirectoryTest = Boolean.parseBoolean(globalsConf.getProperty("generate.all.expected.data"));
        this.generateNewExpectedDirectoryTests = Boolean.parseBoolean(globalsConf.getProperty("generate.new.expected.data"));
        this.actionType = this.generateAllExpectedDirectoryTest || this.generateNewExpectedDirectoryTests ? (this.generateAllExpectedDirectoryTest ? "regenerate all data expected directories if is is not generate manually " : "generate all missing data expected directories ") : "launch tests integration ";
        this.init();
        this.testsToExecute = this.checkValidateTest(tests);
        this.testsInstance = this.initIT();
        this.testsCount = this.testsInstance.size();
        ITLogger.getLogger().config("Found " + this.testsCount + " tests to execute.");
        this.setDebugModeEnabled(Boolean.getBoolean("it.debug.enable"));
    }
}

