/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it.comparator;

import fr.ens.biologie.genomique.eoulsan.util.EnhancedBloomFilter;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.it.comparator.AbstractComparator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public abstract class AbstractComparatorWithBloomFilter
extends AbstractComparator {
    private static final long SIZE_MINIMAL_CREATE_SERIALIZE_FILE = 40000000L;
    private double falsePositiveProbability = 0.1;
    private int expectedNumberOfElements = 30000000;
    private boolean useSerializeFile = false;

    @Override
    public boolean compareFiles(File fileA, File fileB) throws IOException {
        if (!AbstractComparatorWithBloomFilter.checkFiles(fileA, fileB) && this.checkFileSize()) {
            return false;
        }
        if (fileA.getCanonicalFile().equals(fileB.getCanonicalFile())) {
            return true;
        }
        try (FileInputStream isB = new FileInputStream(fileB);){
            boolean bl = this.compareFiles(this.getBloomFilter(fileA), CompressionType.getCompressionTypeByFilename((String)fileB.getAbsolutePath()).createInputStream((InputStream)isB));
            return bl;
        }
    }

    @Override
    public boolean compareFiles(InputStream isA, InputStream isB) throws IOException {
        return this.compareFiles(this.buildBloomFilter(isA), isB);
    }

    public abstract boolean compareFiles(EnhancedBloomFilter var1, InputStream var2) throws IOException;

    protected static EnhancedBloomFilter initBloomFilter(int expectedNumberOfElements) {
        return new EnhancedBloomFilter(expectedNumberOfElements);
    }

    public EnhancedBloomFilter getBloomFilter(File file) throws IOException {
        File bloomFilterSer = new File(file.getAbsolutePath() + ".ser");
        if (this.useSerializeFile && bloomFilterSer.exists()) {
            return EnhancedBloomFilter.deserializationBloomFilter(bloomFilterSer);
        }
        CompressionType zType = CompressionType.getCompressionTypeByFilename((String)file.getAbsolutePath());
        try (FileInputStream is = new FileInputStream(file);){
            EnhancedBloomFilter bloomFilter = this.buildBloomFilter(zType.createInputStream((InputStream)is));
            if (this.isCreateSerializeFile(file, zType)) {
                EnhancedBloomFilter.serializationBloomFilter(bloomFilterSer, bloomFilter);
            }
            EnhancedBloomFilter enhancedBloomFilter = bloomFilter;
            return enhancedBloomFilter;
        }
    }

    protected EnhancedBloomFilter buildBloomFilter(InputStream is) throws IOException {
        EnhancedBloomFilter filter = AbstractComparatorWithBloomFilter.initBloomFilter(this.getExpectedNumberOfElements());
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            filter.put(line);
        }
        reader.close();
        return filter;
    }

    @Override
    public String toString() {
        return this.getName() + " compares files with extensions " + this.getExtensions() + " use Bloom filter with parameters: expected numbers elements " + this.getExpectedNumberOfElements() + " and false positive probability " + this.getFalsePositiveProbability();
    }

    private boolean isCreateSerializeFile(File file, CompressionType zType) {
        if (!this.useSerializeFile) {
            return false;
        }
        if (zType != CompressionType.NONE) {
            return true;
        }
        long fileSize = file.length();
        return fileSize > 40000000L;
    }

    public boolean isUseSerializeFile() {
        return this.useSerializeFile;
    }

    public void setUseSerializeFile(boolean useSerializeFile) {
        this.useSerializeFile = useSerializeFile;
    }

    protected int getExpectedNumberOfElements() {
        return this.expectedNumberOfElements;
    }

    protected void setExpectedNumberOfElements(int expectedNumberOfElements) {
        this.expectedNumberOfElements = expectedNumberOfElements;
    }

    protected void setFalsePositiveProbability(double falsePositiveProbability) {
        this.falsePositiveProbability = falsePositiveProbability;
    }

    protected double getFalsePositiveProbability() {
        return this.falsePositiveProbability;
    }

    public AbstractComparatorWithBloomFilter(boolean useSerializeFile) {
        this.useSerializeFile = useSerializeFile;
    }
}

