/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it.comparator;

import com.google.common.collect.Sets;
import fr.ens.biologie.genomique.eoulsan.util.EnhancedBloomFilter;
import fr.ens.biologie.genomique.kenetre.it.comparator.AbstractComparatorWithBloomFilter;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class BAMComparator
extends AbstractComparatorWithBloomFilter {
    public static final String COMPARATOR_NAME = "BAMComparator";
    private static final Collection<String> EXTENSIONS = Sets.newHashSet((Object[])new String[]{".bam"});
    final Set<String> tagsToNotCompare;
    private int numberElementsCompared;

    @Override
    public boolean compareFiles(EnhancedBloomFilter filter, InputStream in) throws IOException {
        String line = null;
        this.numberElementsCompared = 0;
        SamReader bamReader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)in));
        for (SAMRecord r : bamReader) {
            line = r.getSAMString();
            ++this.numberElementsCompared;
            if (line.charAt(0) == '@') {
                if (this.tagsToNotCompare.contains(BAMComparator.getTag(line)) || filter.mightContain(line)) continue;
                this.setCauseFailComparison(line);
                bamReader.close();
                return false;
            }
            if (filter.mightContain(line)) continue;
            this.setCauseFailComparison(line);
            bamReader.close();
            return false;
        }
        bamReader.close();
        if (this.numberElementsCompared != filter.getAddedNumberOfElements()) {
            this.setCauseFailComparison("Different count elements " + this.numberElementsCompared + " was " + filter.getAddedNumberOfElements() + " expected.");
            return false;
        }
        return true;
    }

    @Override
    protected EnhancedBloomFilter buildBloomFilter(InputStream is) throws IOException {
        EnhancedBloomFilter filter = BAMComparator.initBloomFilter(this.getExpectedNumberOfElements());
        try (SamReader bamReader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)is));){
            for (SAMRecord aBamReader : bamReader) {
                filter.put(aBamReader.getSAMString());
            }
        }
        catch (Exception e) {
            throw new IOException("Fail read BAM file exception: " + e.getMessage());
        }
        return filter;
    }

    private static String getTag(String samHeaderLine) {
        if (samHeaderLine.length() == 0) {
            return "";
        }
        int pos = samHeaderLine.indexOf(9);
        if (pos == -1) {
            return samHeaderLine.substring(1);
        }
        return samHeaderLine.substring(1, pos);
    }

    @Override
    public String getName() {
        return COMPARATOR_NAME;
    }

    @Override
    public Collection<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public int getNumberElementsCompared() {
        return this.numberElementsCompared;
    }

    public BAMComparator(boolean useSerializeFile) {
        super(useSerializeFile);
        this.tagsToNotCompare = new HashSet<String>();
    }

    public BAMComparator(boolean useSerializeFile, String ... headersTags) {
        super(useSerializeFile);
        if (headersTags == null) {
            throw new NullPointerException("headersTags is null");
        }
        this.tagsToNotCompare = Sets.newHashSet((Object[])headersTags);
    }
}

