/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it.comparator;

import com.google.common.collect.Sets;
import fr.ens.biologie.genomique.eoulsan.util.EnhancedBloomFilter;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqReader;
import fr.ens.biologie.genomique.kenetre.it.comparator.AbstractComparatorWithBloomFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public class FastqComparator
extends AbstractComparatorWithBloomFilter {
    public static final String COMPARATOR_NAME = "FastqComparator";
    private static final Collection<String> EXTENSIONS = Sets.newHashSet((Object[])new String[]{".fastq", ".fq"});
    private int numberElementsCompared;

    @Override
    public boolean compareFiles(EnhancedBloomFilter filter, InputStream is) throws IOException {
        FastqReader fastqReader = new FastqReader(is);
        this.numberElementsCompared = 0;
        for (ReadSequence read : fastqReader) {
            ++this.numberElementsCompared;
            if (filter.mightContain(read.toFastQ() + '\n')) continue;
            this.setCauseFailComparison(read.toFastQ() + '\n');
            fastqReader.close();
            return false;
        }
        fastqReader.close();
        if (this.numberElementsCompared != filter.getAddedNumberOfElements()) {
            this.setCauseFailComparison("Different count elements " + this.numberElementsCompared + " was " + filter.getAddedNumberOfElements() + " expected.");
            return false;
        }
        return true;
    }

    @Override
    protected EnhancedBloomFilter buildBloomFilter(InputStream is) throws IOException {
        EnhancedBloomFilter filter = FastqComparator.initBloomFilter(this.getExpectedNumberOfElements());
        FastqReader fastqReader = new FastqReader(is);
        for (ReadSequence read : fastqReader) {
            filter.put(read.toFastQ() + '\n');
        }
        fastqReader.close();
        try {
            fastqReader.throwException();
        }
        catch (BadBioEntryException e) {
            throw new IOException("Fail BadBioEntry exception: " + e.getMessage());
        }
        return filter;
    }

    @Override
    public Collection<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return COMPARATOR_NAME;
    }

    @Override
    public int getNumberElementsCompared() {
        return this.numberElementsCompared;
    }

    public FastqComparator(boolean useSerializeFile) {
        super(useSerializeFile);
    }
}

