/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it.comparator;

import com.google.common.collect.Sets;
import fr.ens.biologie.genomique.eoulsan.util.EnhancedBloomFilter;
import fr.ens.biologie.genomique.kenetre.it.comparator.AbstractComparatorWithBloomFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SAMComparator
extends AbstractComparatorWithBloomFilter {
    public static final String COMPARATOR_NAME = "SAMComparator";
    private static final Collection<String> EXTENSIONS = Sets.newHashSet((Object[])new String[]{".sam"});
    final Set<String> tagsToNotCompare;
    private int numberElementsCompared;

    @Override
    public boolean compareFiles(EnhancedBloomFilter filter, InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));
        String line = null;
        this.numberElementsCompared = 0;
        while ((line = reader.readLine()) != null) {
            ++this.numberElementsCompared;
            if (line.charAt(0) == '@') {
                if (this.tagsToNotCompare.contains(SAMComparator.getTag(line)) || filter.mightContain(line)) continue;
                this.setCauseFailComparison(line);
                reader.close();
                return false;
            }
            if (filter.mightContain(line)) continue;
            this.setCauseFailComparison(line);
            reader.close();
            return false;
        }
        reader.close();
        if (this.numberElementsCompared != filter.getAddedNumberOfElements()) {
            this.setCauseFailComparison("Different count elements " + this.numberElementsCompared + " was " + filter.getAddedNumberOfElements() + " expected.");
            return false;
        }
        return true;
    }

    private static String getTag(String samHeaderLine) {
        if (samHeaderLine.length() == 0) {
            return "";
        }
        int pos = samHeaderLine.indexOf(9);
        if (pos == -1) {
            return samHeaderLine.substring(1);
        }
        return samHeaderLine.substring(1, pos);
    }

    @Override
    public String getName() {
        return COMPARATOR_NAME;
    }

    @Override
    public Collection<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public int getNumberElementsCompared() {
        return this.numberElementsCompared;
    }

    public SAMComparator(boolean useSerializeFile) {
        super(useSerializeFile);
        this.tagsToNotCompare = new HashSet<String>();
    }

    public SAMComparator(boolean useSerializeFile, String ... headersTags) {
        super(useSerializeFile);
        if (headersTags == null) {
            throw new NullPointerException("headersTags is null");
        }
        this.tagsToNotCompare = Sets.newHashSet((Object[])headersTags);
    }
}

